<?php

namespace Clevercherry\Backslash4\Models;

use \Clevercherry\Backslash4\Models\Model;

class Address extends Model
{

    public const  TYPE_DELETED  = 0;
    public const  TYPE_SHIPPING = 1;
    public const  TYPE_BILLING  = 2;

    /**
     * Override default
     */
    public function hasBlocks()
    {
        return false;
    }

    public function getShortName()
    {        
        $short = $this->address_shortname ?? '';
        if(!empty($short))
            $short .= ', ';
        $short .= $this->address_1 ?? '';

        if(!empty($short))
            $short .= ', ';
        $short .= $this->postcode ?? '';

        $short = trim($short, ", \n\r\t\v\x00");
        if(empty($short))
            $short='#'.$this->id;

        return $short;
    }

    public static function getAddresses($client_id, $type)
    {
        return self::where('client_id', $client_id)->AddressType($type)->get();
    }

    public function scopeAddressType($query, $type)
    {
        $query->whereRaw("type & {$type} = {$type}");
    }
 
}