<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Order;
use Clevercherry\Backslash4\Traits\cartControl;

class OrderController extends Controller
{
    use cartControl;
    public static $cartName = 'cart';

    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = Order::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::orders.index'))
            return view('tenant::orders.index')->with('items', $items);
        //else

        if(view()->exists('orders.index'))
            return view('orders.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        if( empty(Request()->preview) 
            || empty(Order::allowPreviewAlgorithm()) 
            ||  (Request()->preview!=hash( Order::allowPreviewAlgorithm(), end($params)) ) )
        {
            $item = Order::where('id', end($params))->active()->first();
        } else
        {
            // preview param exists and matches the slug's hash so allow any pages
            $item = Order::where('id', end($params))->first();
        }

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::orders.view'))
            return view('tenant::orders.view')->with('item', $item);
        //else

        if(view()->exists('orders.view')) {
            return view('orders.view')->with('item', $item);
        }
        //else

        if(view()->exists('generic.view')) {
            return view('generic.view')->with('item', $item);
        }
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
    

    //override trait because order carts also have delivery method
    public static function saveCart($cart = null)
    {
        if(empty($cart))
            $cart = self::getCalcCart();
        
        if(isset($cart['id']) && !empty($cart['id']))
        {
            Order::where('id', $cart['id'])->update(
                [   'items' => json_encode($cart['items']),
                    'total_nett' => $cart['total_nett'],
                    'total_shipping' => $cart['shipping'],
                    'total_gross' => $cart['total_gross'],
                    'delivery_method' => json_encode([ 'name'=> @$cart['carrier']])
                ]);

        } else
        {
            $newOrder = new Order;
            $newOrder->items = json_encode($cart['items']);
            $newOrder->total_nett = $cart['total_nett'];
            $newOrder->total_gross = $cart['total_gross'];
            $newOrder->total_shipping = $cart['shipping'];
            $newOrder->delivery_method =  json_encode([ 'name'=> @$cart['carrier']]);
            $newOrder->save();
            $cart['id'] = $newOrder->id;
        }

        self::putCart($cart);
    }
}
