<?php
namespace Clevercherry\Backslash4\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\MediaManager;

class MediaManagerController extends Controller
{
    /**
     * Returns the index page view
     * @return type
     */
    public function index()
    {
        $items = MediaManager::active()->get();

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::mediamanager.index'))
            return view('tenant::mediamanager.index')->with('items', $items);
        //else

        if(view()->exists('mediamanager.index'))
            return view('mediamanager.index')->with('items', $items);
        //else

        return view('backslash4::generic.index')->with('items', $items);
    }
 
    /**
     * Returns a template / content page view
     * @param array $params    presuming the last parametre is the {slug} $slug -- override in your model if necessary     * @return type
     * @return type
     */
    public function view(...$params)
    {
        $item = MediaManager::where('slug', end($params))->active()->first();

        if(!$item) {
            abort(404);
        }

        if((config('backslash4.tenants-on',0)!=0) && view()->exists('tenant::mediamanager.view'))
            return view('tenant::mediamanager.view')->with('item', $item);
        //else

        if(view()->exists('mediamanager.view'))
            return view('mediamanager.view')->with('category', $item);
        //else

        return view('backslash4::generic.view')->with('item', $item);
    }
}
