<?php
namespace Clevercherry\Backslash4\Controllers\Admin;

use Illuminate\Http\Request;
use Clevercherry\Backslash4\Controllers\Controller;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\View;
use App\Models\Product;
use App\Models\Block;
use Clevercherry\Backslash4\Traits\checkControllerSecurityAbort;

class ProductController extends BkAdminController
{
    use checkControllerSecurityAbort;

    //public $adminView = 'backslash4::products';  // uses generic
    public $adminRoute = 'admin.products';
    public $AppModel = Product::class;


    public function store(Request $request)
    {
        $this->checkControllerSecurityAbort($this->AppModel);

        $model = new $this->AppModel;
        $model->setDynamicFillable();

        $store = $request->except("_token");

        if(!isset($store['slug']) || empty($store['slug']))
            $store['slug'] =  $this->makeSlug($store['name']);
        
        if(!isset($store['active']))
            $store['active']=0;
        
        //all prices are stored in pennies/cents
        if(isset($store['price']) && !empty($store['price']))
            $store['price'] = $store['price']*100;
        if(isset($store['price2']) && !empty($store['price2']))
            $store['price2'] = $store['price2']*100;

        $blocks=null;
        if(isset($store['blocks']))
            $blocks = $store['blocks'];
        
        $store = $this->checkBeforeSave($store);
        unset($store['blocks']);
        $item = ($this->AppModel)::create($store);

        if($item->hasBlocks() && $blocks!==null)
            Block::updateBlocks($this->AppModel, $item->id, $blocks);

        $this->postStoreProcess($item);


        return $this->bs4StoreResponse($model, $item);
        //return redirect( route($this->adminRoute.'.index') );
    }

    public function update(Request $request)
    {
        $this->checkControllerSecurityAbort($this->AppModel);

        $model = new $this->AppModel;
        $model->setDynamicFillable();
        
        $store = $request->except("_token");

        if(!isset($store['slug']) || empty($store['slug']))
            $store['slug'] =  $this->makeSlug($store['name']);

        if(!isset($store['active']))
            $store['active']=0;

        //all prices are stored in pennies/cents
        if(isset($store['price']) && !empty($store['price']))
            $store['price'] = $store['price']*100;
        if(isset($store['price2']) && !empty($store['price2']))
            $store['price2'] = $store['price2']*100;

        $blocks=null;
        if(isset($store['blocks']))
            $blocks = $store['blocks'];
        
        $store = $this->checkBeforeSave($store);
        unset($store['blocks']);
        $item = ($this->AppModel)::where('id', $store['id'])->first();
        $item->update($store);

        if($item->hasBlocks() && ($blocks!=null))
            Block::updateBlocks($this->AppModel, $store['id'], $blocks);

        $this->postUpdateProcess($item);


        return $this->bs4UpdateResponse($model, $item);
        //return redirect()->back();
    }

}
