<?php
namespace Clevercherry\Backslash4\Console;

class Backslash4Install extends Backslash4Command
{
    protected $name = 'backslash:install';
    protected $signature = 'backslash:install';
    protected $description = 'Install Backslash4 and parts thereof';

    public function handle()
    {
        $this->clearMsg();
        $option='999';
        while($option!=='0')
        {
            $this->newLine();
            $this->info('Backslash4 Installer');
            $this->info('--------------------');
            $this->showStatus();

            $option = $this->showMenu();

            $this->doAction($option);        
        }
    }

    private function showMenu()
    {
        $this->newLine();
        $this->menuLine(0,'Exit Backslash4 Installer');
        $this->menuLine(2,'Show Status');
        $this->menuLine(41,'Deploy/Update Config'); // vendor:publish --tag=backslash4-config
        $this->menuLine(44,'Add Module');
        $this->menuLine(45,'Add s3 to ENV');
        $this->menuLine(49,'Deploy & Upgrade All');
        $this->menuLine(51,'Add User');
        $this->menuLine(52,'List Users');
        $this->menuLine(53,'Add Dashboard Admin');
        $this->menuLine(54,'List Dashboard Admins');
        
        $this->newLine();

        $this->showMsg();

        return $this->ask('Select a menu option');
    }   
}