@props([
    'label' => null,
    'value' => null,
    'icon' => 'folder',
    'name' => "media-upload-folder"
    ])
@php
    $id = 'bs4-upload-folder-'.Str::slug($value);
    $attributes = $attributes->class([
        'mb-2','mr-2',
    ])->merge([]);
@endphp
<div {{ $attributes }} data-type="folder-tag">
    <input class="sr-only" type="radio" name="{{ $name }}" id="{{ $id }}" value="{{ $value }}">
    <label class="button" data-theme="primary" data-outline="true" for="{{ $id }}">
        <x-bs-icon
            class="h-4 w-4 mr-2"
            icon="{{ $icon }}"
            size="md"
        />
        <span data-label>{{ $label }}</span>
    </label>
</div>