@props([
    'controls' => null,
    'label' => null,
    'selected' => false,
])

@php
    $attributes = $attributes
        ->merge([
            'aria-controls' => $controls,
            'aria-selected' => 'false',
            ':aria-selected' => "tab === '$controls'",
            'x-on:click.prevent' => "tab = '$controls'"
        ])
        ->class([
            'tabs__nav-item'
        ]);
@endphp
    
<button {{ $attributes }} role="tab" tabindex="0">
    {{ $label }}
</button>