@props([
    'header' => true,
    'sidebar' => true,
    'title' => 'CleverCherry CMS Dashboard Backslash4'
])

@php
    $staging_banner = '';

    if (env('APP_ENV') == 'staging' || env('APP_ENV') == 'local') {
        if (view()->exists('tenant::admin.body-start') || view()->exists('admin.body-start')) {
            $staging_banner = 'staging-banner';
        }
    }
@endphp

<!DOCTYPE html>
<html lang="en" x-data data-theme="light" :data-theme="$store.global.theme">
    <head>
        @stack('admin.head.start')
        <x-bs-js.network-script />
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        <title>{{ $title }}</title>

        <link rel="apple-touch-icon" sizes="57x57" href="/images/icon/apple-icon-57x57.png">
        <link rel="apple-touch-icon" sizes="60x60" href="/images/icon/apple-icon-60x60.png">
        <link rel="apple-touch-icon" sizes="72x72" href="/images/icon/apple-icon-72x72.png">
        <link rel="apple-touch-icon" sizes="76x76" href="/images/icon/apple-icon-76x76.png">
        <link rel="apple-touch-icon" sizes="114x114" href="/images/icon/apple-icon-114x114.png">
        <link rel="apple-touch-icon" sizes="120x120" href="/images/icon/apple-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="144x144" href="/images/icon/apple-icon-144x144.png">
        <link rel="apple-touch-icon" sizes="152x152" href="/images/icon/apple-icon-152x152.png">
        <link rel="apple-touch-icon" sizes="180x180" href="/images/icon/apple-icon-180x180.png">
        <link rel="icon" type="image/png" sizes="192x192"  href="/images/icon/android-icon-192x192.png">
        <link rel="icon" type="image/png" sizes="32x32" href="/images/icon/favicon-32x32.png">
        <link rel="icon" type="image/png" sizes="96x96" href="/images/icon/favicon-96x96.png">
        <link rel="icon" type="image/png" sizes="16x16" href="/images/icon/favicon-16x16.png">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

        @vite(['resources/scss/admin.scss'])

        <style>
            [x-cloak] {
                display: none;
            }
        </style>

        <script>
            var theme = localStorage.getItem("_x_theme");
            document.documentElement.setAttribute('data-theme', JSON.parse(theme));
        </script>
        @stack('admin.head.end')
    </head>
    @if (\Session::has('bs4response'))
        @php
            $bs4response = session('bs4response');
            $bs4responseTheme = 'primary';
            
            switch (@$bs4response['status']) {
                case ('ERROR'):
                    $bs4responseTheme = 'error';
                    break;
                case ('DELETED'):
                    $bs4responseTheme = 'error';
                    break;
                case ('OK'):
                    $bs4responseTheme = 'success';
                    break;
                default:
                    $bs4responseTheme = 'primary';
                    break;
            }
        @endphp
    <body
        class="{{ $staging_banner }}"
        x-data
        x-init="$nextTick(() => {
                $dispatch('alert', {
                    type: '{{ $bs4responseTheme }}',
                    title: '{{ @$bs4response['title'] }}',
                    message: '{{ @$bs4response['message'] }}',
                })
            }
        )"
    >
    @else
    <body class="{{ $staging_banner }}">
    @endif
        @stack('admin.body.start')
        @includeFirst(['tenant::admin.body-start', 'admin.body-start', 'backslash4::admin.body-start'])
        @if ($sidebar)
            <x-bs-admin.sidebar class="{{ $staging_banner }}"/>
        @endif
        @if ($header)
            <x-bs-admin.header />
        @endif
        {{ $slot }}
        <script src="https://code.jquery.com/jquery-3.6.1.min.js"></script>
        @vite(['resources/js/admin.js'])
 
        <script>
            document.addEventListener('alpine:init', () => {
                Alpine.store('global', {
                    theme: Alpine.$persist('light'),
                    menu: false,
        
                    toggleTheme: function() {
                        if (this.theme === 'light') {
                            this.theme = 'dark';
                        } else {
                            this.theme = 'light';
                        }
                    },
                    toggleMenu: function() {
                        this.menu = !this.menu;
                    }
                })
            })
        </script>

        <x-bs-notifications />
        @stack('admin.body.end')
    </body>
</html>