@props([
    'tableName' => 'null',
    'title' => null,
    'message' => null,
    'itemname' => null,
])
@php
    if($title==null)
        $title = 'Delete '. $itemname;

    if($message==null)
        $message = "Are you sure you want to delete this " . strtolower($itemname) ."? This action cannot be undone.";
@endphp

<x-bs-modal id="delete-media-folder-modal" size="sm">
    <x-bs-modal.header
        :icon="[
            'icon' => 'trash',
            'theme' => 'error'
        ]"
        title="{{ $title }}"
        text="{!! $message !!}"
    />
    <x-bs-modal.content>
        <p>{{ $itemname }}</p>
    </x-bs-modal.content>
    <x-bs-modal.actions>
        <x-bs-button
            size="lg"
            text="Cancel"
            theme="secondary"
            type="button"
            data-a11y-dialog-hide
            aria-label="Close dialog" 
        />
        <form method="post" action="{{ route('admin.mediamanager.rmdir') }}">
        @csrf
        <input type="hidden" name="rmdir" value="images/{{ $itemname }}" />
        <x-bs-button 
            size="lg"
            text="Delete Folder"
            theme="error"
            type="submit" 
        />
        </form>
    </x-bs-modal.actions>
</x-bs-modal>