@props([
    'id' => 'add-folder-modal',
    'guid' => uniqid('bs4dialog',true)
])

<x-bs-modal id="{{ $id.'-'.$guid }}" size="md" data-role="add-folder-modal">
    <x-bs-modal.header
        direction="row"
        :icon="[
            'icon' => 'folder-plus',
            'theme' => 'primary'
        ]"
        title="Create new folder"
        text="Create a new folder to save media in."
    />
    <x-bs-modal.content>
        <x-bs-form.input
            id="dirname"
            label="Folder name"
        />
    </x-bs-modal.content>
    <x-bs-modal.actions>
        <x-bs-modal.footer-yesno 
            yes="Create"
            no="Cancel" 
        />
    </x-bs-modal.actions>
</x-bs-modal>
