@props([
    'id' => null,
    'size' => 'md'
])

@php
    $attributes = $attributes
        ->merge([
            'aria-hidden' => "true",
            'aria-modal' => true,        
            'id' => $id,
            'data-size' => $size,
            'data-a11y-dialog' => $id
        ])
        ->class([
            'modal'
        ]);
@endphp

<div {{ $attributes }}>
    <div class="modal__overlay"></div>
    <input type="hidden" data-a11y-dialog-show="{{ $id }}" />{{-- hidden helper to open the dialog --}}
    <div class="modal__window">
        <button class="modal__close" type="button" data-a11y-dialog-hide>
            <x-bs-icon 
                icon="cross" 
            />
        </button>
        {{ $slot }}
    </div>
</div>