@props([
    'type' => null,
    'href' => null,
    'icon' => null,
    'text' => null,
    'dataAction' => ''
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'menu__item'
        ]);
@endphp

@if (!empty($type))
    <button {{ $attributes->merge(['type' => $type]) }} data-action="{{ $dataAction }}">
        @if (!empty($icon))
            <span class="menu__item-icon" data-action="{{ $dataAction }}">
                <x-bs-icon
                    :icon=$icon
                    size="xs"
                />
            </span>
        @endif
        <span class="menu__item-text" data-action="{{ $dataAction}}">
            {{ $text ?? $slot }}
        </span>
    </button>
@elseif (!empty($href))
    <a {{ $attributes->merge(['href' => $href]) }} data-action="{{ $dataAction }}">
        @if (!empty($icon))
            <span class="menu__item-icon" data-action="{{ $dataAction }}">
                <x-bs-icon
                    :icon=$icon
                    size="xs"
                />
            </span>
        @endif
        <span class="menu__item-text" data-action="{{ $dataAction }}">
            {{ $text ?? $slot }}
        </span>
    </a>
@else
    <div {{ $attributes }} data-action="{{ $dataAction }}">
        @if (!empty($icon))
            <span class="menu__item-icon" data-action="{{ $dataAction }}">
                <x-bs-icon
                    :icon=$icon
                    size="xs"
                />
            </span>
        @endif
        <span class="menu__item-text" data-action="{{ $dataAction }}">
            {{ $text ?? $slot }}
        </span>
    </div>
@endif