@props([
    'thumbnail' => null,
    'type' => 'image',
    'extension' => null,
    'name' => null,
    'size' => null,
    'showdelete' => 0,
    'file' => null,
        /** file: { "filename":"1920x1080_(3).opt.webp",
                    "extension":"webp",
                    "cTime":"2023-06-05 12:47:15",
                    "size":6772,
                    "url":"https:\/\/backslash.fra1.digitaloceanspaces.com\/Peveril Homes Brand Portal\/file\/Test Assets\/1920x1080_(3).opt.webp"
                  }
         */
])

@php
    if(empty($thumbnail))
    {
        $thumbnail = @$attributes['data-url'];
    }
    $attributes = $attributes
        ->merge([
            'data-media-type' => $type
        ])
        ->class([
            'media-library__item',
        ]);
@endphp

<div {{ $attributes }}>
    <div class="media-library__item-preview">
        @if(!empty($showdelete))
        <div style="pointer-events:auto;position:relative;margin:3px 3px 0px 0px;z-index:49;float:right;background-color:white;border:1px solid silver;padding:2px;min-width:1.5em;text-align:center;border-radius:0.3em;"
                xxdata-a11y-dialog-show="file-confirm-delete-modal"
                data-action="media-libraray-delete-item" 
                data-name="{{ @$file['filename'] }}"
                data-url="{{ @$file['url'] }}">X</div>
        @endif
        <div class="media-library__item-preview-inner">

            @if( ($type === 'image') || in_array($extension,['jpg','webp','png','gif']) )
                @if (!empty($thumbnail))
                    <img class="media-library__item-preview-thumbnail" src="{{ $thumbnail }}">
                @endif
            @elseif ($type === 'file')
                @switch ($extension)
                    @case ('pdf')
                        <x-bs-icon
                            class="text-error-600"
                            icon="file"
                            size="lg"
                        />
                        @break
                    @case ('doc')
                    @case ('docx')
                    @case ('odt')
                        <x-bs-icon
                            class="text-blue-600"
                            icon="file"
                            size="lg"
                        />
                        @break
                    @case ('xls')
                    @case ('xlsx')
                    @case ('ods')
                    @case ('csv')
                        <x-bs-icon
                            class="text-success-600"
                            icon="file"
                            size="lg"
                        />
                        @break
                    @default
                        @break
                @endswitch
                {{ $extension }}
            @endif
        </div>
    </div>
    <div class="media-library__item-description">
        @if (!empty($name)) 
            <p class="text-sm" style="word-break: break-all;">{!! $name !!}</p>
        @endif
        @if (!empty($size))
            <p class="mt-1 text-body-tertiary text-xs">{{ \Clevercherry\Backslash4\Backslash4::formatBytes($size) }}</p>
        @endif
    </div>
    <div class="sr-only">
    {!! str_replace(['.', '-', '_'], ['&#8203;.', '&#8203;-', '&#8203;_'], $attributes['data-media-filename']) !!}<br />
            {{ $attributes['data-media-width'] }} x {{ $attributes['data-media-height'] }}
    </div>
</div>