@props([
    'id' => null,
    'pin'=> null,
    'checked' => true,
    'showcontrols' => true,
    'hidden' => false,
])

<x-bs-search.item style="{{ $hidden ? 'display: none;' : '' }}"  data-role="pin-tile" data-name="{{ $pin->name }}" data-latitude="{{ $pin->geometry->location->lat }}"  data-longitude="{{ $pin->geometry->location->lng }}"  data-uid="{{ $pin->place_id }}" data-selected="false">
    <div class="command-menu__item-content">
        <div data-role="pin-json" style="display: none;">{{ json_encode($pin, JSON_PRETTY_PRINT )}}</div>
        <div class="font-medium text-body text-sm" data-role="tile-name">{{ $pin->name }}</div>
        {{-- <div class="text-body-tertiary text-sm">Location: <span data-role="tile-lnglat">{{ $pin->geometry->location->lng }}, {{ $pin->geometry->location->lat }}</span></div> --}}
        <div class="font-light mt-2 text-body-tertiary text-sm" data-role="tile-address">{{ $pin-> formatted_address }}</div>
    </div>
    @if ($showcontrols)
        <div class="search__results-item-controls">
            <x-bs-button 
                data-action="tile-remove"
                icon="trash"
                iconPosition="only"
                size="sm"
                theme="secondary"
                type="button" 
            />
            <x-bs-form.switch 
                label="Visible"
                value="1" 
                data-action="pin-switch" 
                :checked=$checked 
                for="{{ $id }}" 
                data-pinid="{{ $pin->place_id }}"
            />
        </div>
    @endif

    {{--
        {   "formatted_address": "Community Primary School, Mill Ln, Chinnor OX39 4RF, United Kingdom",
            "geometry": {   "location": { "lat": 51.70341999999999, "lng": -0.9176316 }, 
                            "viewport": { "south": 51.70189882010728, "west": -0.9188278298927222, "north": 51.70459847989272, "east": -0.916128170107278 } 
                        },
            "icon": "https:\/\/maps.gstatic.com\/mapfiles\/place_api\/icons\/school-71.png", 
            "id": "a7e961185ddda6b86c715a70d976660182591455", 
            "name": "Windmill Community Nursery", 
            "photos": [ { "height": 4045, 
                        "html_attributions": [ "<a href=\"https:\/\/maps.google.com\/maps\/contrib\/109083053799941315002\">Paul Snook<\/a>" ], 
                        "width": 6401 } 
                    ], 
            "place_id": "ChIJiccR1efydkgRbSsfmUjaaZ8", 
            "plus_code": { "compound_code": "P33J+9W Chinnor", "global_code": "9C3XP33J+9W" }, 
            "rating": 4.6, 
            "reference": "ChIJiccR1efydkgRbSsfmUjaaZ8", 
            "types": [ "primary_school", "school", "point_of_interest", "establishment" ],
            "user_ratings_total": 5, "html_attributions": []

            "active":0 //<<-- optional if not exists then is set
        
            --}}
</x-bs-search.item>
