@props([
  'item' => null,
  'defaultOrganisation' => '',
  'defaultEmail' => '',
  'includeLDJSON' => true,
  'includeFacebook' => true,
  'includeTwitter' => true,
  'imageUrl' => null,
  'seo_name' => null,
  'seo_desc' => null,
])

@php
use Carbon\Carbon;
use \App\Models\Setting;

if ($item == null) {
  $item = new \App\Models\Page;
}

if (empty($imageUrl) && ($includeFacebook || $includeTwitter)) {
  $image = Setting::getSettingMedia('seo-media-image', true);
  if (!empty($image)) {
    $imageUrl = str_replace(' ', '%20', $image->getUrl());
  }
}

if (empty($seo_name)) {
  $seo_name = @$item->getSEOName();
  $seo_name = str_replace(['#039;', ';amp;', '&amp;amp;', '&amp;'], [';', ';', '&', '&'], $seo_name);
}

if (empty($seo_desc)) {
  $seo_desc = @$item->getSEODescription();
  $seo_desc = str_replace(['#039;', ';amp;', '&amp;amp;', '&amp;'], [';', ';', '&', '&'], $seo_desc);
}

// Prepare JSON data for LD+JSON scripts

$organizationData = [
    "@context" => "http://schema.org",
    "@type" => "Organization",
    "name" => Setting::getSetting('seo-organization-name', $defaultOrganisation),
    "url" => URL::current(),
    "description" => $seo_desc,
    "address" => [
        [
            "@type" => "PostalAddress",
            "addressLocality" => Setting::getSetting('seo-address-locality', 'UK'),
            "addressRegion" => Setting::getSetting('seo-address-region', 'UK'),
            "postalCode" => Setting::getSetting('seo-address-postcode', 'UK'),
            "streetAddress" => Setting::getSetting('seo-address-line', 'UK'),
        ]
    ],
    "contactPoint" => [
        [
            "@type" => "ContactPoint",
            "telephone" => Setting::getSetting('seo-contact-phone', 'UK'),
            "contactType" => Setting::getSetting('seo-contact-type', 'customer service'),
            "areaServed" => Setting::getSetting('seo-contact-area', 'UK'),
        ]
    ]
];

$localBusinessData = [
    "@context" => "http://schema.org",
    "@type" => "LocalBusiness",
    "name" => Setting::getSetting('seo-organization-name', $defaultOrganisation),
    "image" => $imageUrl,
    "telephone" => Setting::getSetting('seo-contact-phone', 'UK'),
    "email" => Setting::getSetting('seo-organization-email', $defaultEmail),
    "address" => [
        "@type" => "PostalAddress",
        "streetAddress" => Setting::getSetting('seo-address-line', 'UK'),
        "addressRegion" => Setting::getSetting('seo-address-region', 'UK'),
        "addressCountry" => Setting::getSetting('seo-contact-area', 'UK'),
        "postalCode" => Setting::getSetting('seo-address-postcode', 'UK'),
    ],
    "openingHours" => "Mo,Tu,We,Th,Fr 09:00-17:00",
    "openingHoursSpecification" => [
        [
            "@type" => "OpeningHoursSpecification",
            "opens" => "09:00",
            "closes" => "17:00",
            "dayOfWeek" => [
                ["@value" => "Monday"],
                ["@value" => "Tuesday"],
                ["@value" => "Wednesday"],
                ["@value" => "Thursday"],
                ["@value" => "Friday"],
                ["@value" => "Saturday"],
            ],
        ]
    ],
    "url" => URL::current(),
];

$articleData = null;
if ($item instanceof \App\Models\Blog || $item instanceof \App\Models\News) {
    $articleData = [
        "@context" => "http://schema.org",
        "@type" => "Article",
        "mainEntityOfPage" => [
            "@type" => "WebPage",
            "@id" => URL::current(),
        ],
        "headline" => $item->name,
        "description" => $item->short_description,
        "image" => $item->getFirstMedia('media_thumbnail') ? $item->getFirstMedia('media_thumbnail')->url() : '',
        "author" => [
            "@type" => "Person",
            "name" => $item->author,
        ],
        "publisher" => [
            "@type" => "Organization",
            "name" => Setting::getSetting('seo-organization-name', $defaultOrganisation),
            "logo" => [
                "@type" => "ImageObject",
                "url" => $imageUrl,
            ],
        ],
        "datePublished" => Carbon::parse($item->date_published)->format('Y-m-d'),
        "dateModified" => Carbon::parse($item->updated_at)->format('Y-m-d'),
    ];
}
@endphp

<title>{!! html_entity_decode($seo_name, ENT_QUOTES, 'UTF-8') !!}</title>
<meta name="description" content="{{ $seo_desc }}" />

@if($includeLDJSON)
<script type="application/ld+json">
{!! json_encode($organizationData, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
</script>

<script type="application/ld+json">
{!! json_encode($localBusinessData, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
</script>
@endif

@if ($articleData)
<script type="application/ld+json">
{!! json_encode($articleData, JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) !!}
</script>
@endif

@if($includeFacebook)
    <!-- Facebook Meta Tags -->
    <meta property="og:url" content="{{ URL::current() }}">
    <meta property="og:type" content="website">
    <meta property="og:title" content="{!! $seo_name !!}">
    <meta property="og:description" content="{!! $seo_desc !!}">
    <meta property="og:image" content="{!! $imageUrl !!}">
    <meta property="og:image:url" content="{!! $imageUrl !!}">
@endif

@if($includeTwitter)
    <!-- Twitter Meta Tags -->
    <meta name="twitter:card" content="summary_large_image">
    <meta property="twitter:domain" content="{{ Request::server('HTTP_HOST') }}">
    <meta property="twitter:url" content="{{ URL::current() }}">
    <meta name="twitter:title" content="{!! $seo_name !!}">
    <meta name="twitter:description" content="{!! $seo_desc !!}">
    <meta name="twitter:image" content="{!! $imageUrl !!}">
@endif