@props([
    'columns' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ],
    'gap' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ],
    'columnGap' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ],
    'rowGap' => [
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ]
])

@php
    $columns = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $columns);

    $gap = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $gap);
    
    $columnGap = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $columnGap);
    
    $rowGap = array_merge([
        'xs' => null,
        'sm' => null,
        'md' => null,
        'lg' => null,
        'xl' => null,
        '2xl' => null,
    ], $rowGap);

    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'display-grid',
            'grid-cols-' . $columns['xs'] => isset($columns['xs']),
            'gap-' . $gap['xs'] => isset($gap['xs']),
            'col-gap-' . $columnGap['xs'] => isset($columnGap['xs']),
            'row-gap-' . $rowGap['xs'] => isset($rowGap['xs']),
            'sm:grid-cols-' . $columns['sm'] => isset($columns['sm']),
            'sm:gap-' . $gap['sm'] => isset($gap['sm']),
            'sm:col-gap-' . $columnGap['sm'] => isset($columnGap['sm']),
            'sm:row-gap-' . $rowGap['sm'] => isset($rowGap['sm']),
            'md:grid-cols-' . $columns['md'] => isset($columns['md']),
            'md:gap-' . $gap['md'] => isset($gap['md']),
            'md:col-gap-' . $columnGap['md'] => isset($columnGap['md']),
            'md:row-gap-' . $rowGap['md'] => isset($rowGap['md']),
            'lg:grid-cols-' . $columns['lg'] => isset($columns['lg']),
            'lg:gap-' . $gap['lg'] => isset($gap['lg']),
            'lg:col-gap-' . $columnGap['lg'] => isset($columnGap['lg']),
            'lg:row-gap-' . $rowGap['lg'] => isset($rowGap['lg']),
            'xl:grid-cols-' . $columns['xl'] => isset($columns['xl']),
            'xl:gap-' . $gap['xl'] => isset($gap['xl']),
            'xl:col-gap-' . $columnGap['xl'] => isset($columnGap['xl']),
            'xl:row-gap-' . $rowGap['xl'] => isset($rowGap['xl']),
            'xxl:grid-cols-' . $columns['2xl'] => isset($columns['2xl']),
            'xxl:gap-' . $gap['2xl'] => isset($gap['2xl']),
            'xxl:col-gap-' . $columnGap['2xl'] => isset($columnGap['2xl']),
            'xxl:row-gap-' . $rowGap['2xl'] => isset($rowGap['2xl']),
        ]);
@endphp

<div {{ $attributes }}>
    {{ $slot }}
</div>