@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'type' => 'hidden',
    'value' => '{"ids":[]}',
    'alltags' => [],
    'buttonname' => 'Add Item',
    'hint' => '',
    'name' => '',
    'bsblockindex' => null,     //make it compatible with block input fields
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'input',
        ]);

    $tags=[];
    if(empty($value))
    {   $value='{"ids":[]}';
    } else
    {   
        $js = json_decode($value,true);
        if(isset($js['ids']))
            $tags = $js['ids'];
    }
@endphp

<x-bs-form.group class="{{ $group['class'] }}">
    <x-bs-form.label 
        :label=$label 
        for="{{ $id }}" 
        :hint=$hint 
    />
    <input 
        @if(!empty($bsblockindex)) bsblockindex="{{ $bsblockindex }}" @endif
        class="sr-only"
        id="{{ $id }}" 
        name="{{ $name }}" 
        type="{{ $type }}" 
        value="{{ $value }}" 
    />

    <x-bs-tag-list data-role="tag-list">
        @foreach($tags as $tagid)
            <x-bs-tag 
                :data-id=$tagid
                :label=@$alltags[$tagid]
                removable="true"
            />
        @endforeach
    </x-bs-tag-list>

    <x-bs-tag
        icon="plus"
        label="Add new"
        type="button"
        data-action="add-tag-modal"
    />
    
    <x-bs-modal id="tag-{{ $id }}-modal" size="xl">
        <x-bs-modal.header
            direction="row"
            :icon="[
                'icon' => 'plus-circle',
                'theme' => 'primary'
            ]"
            title="Add {{ $label }}"
            text="Add a new {{ $label }} to this list."
        />
        <x-bs-modal.content>
            <x-bs-modal.filters>
                <div class="form-group w-full sm:w-80" data-icon="start">
                    <x-bs-icon
                        class="text-gray-500"
                        icon="search" 
                    />
                    <input class="input" placeholder="Search" type="text" data-action="tag-modal-search">
                </div>
            </x-bs-modal.filters>
            <x-bs-tag-list id="tag-modal-list" data-roles="tag-list">
                @foreach($alltags as $key => $tag)
                    <x-bs-tag
                        data-a11y-dialog-hide
                        data-action="add-tag-button"
                        data-id="{{ $key }}"
                        data-name="{{ $tag }}"
                        :label="$tag"
                        type="button"
                    />
                @endforeach
            </x-bs-tag-list>
        </x-modal.content>
    </x-bs-modal>
</x-bs-form.group>