@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'type' => 'checkbox',
    'switch' => false,
    'required' => '',
    'hint' => '',
    'readonly' => false
])


@php
    $attributes = $attributes->class([
        'switch__input',
    ])->merge([
    ]);

    if(!empty($readonly) && ( ($readonly==='readonly') || \Clevercherry\Backslash4\Backslash4::is_true($readonly, false)))
        $readonly='disabled readonly';
    else
        $readonly='';
@endphp

<x-bs-form.group class="{{ $group['class'] }}">
    <div class="switch" {{ $switch ? "data-switch=true" : "" }}>
        <input 
            {{ $attributes }} 
            {{ $id  ? "id=$id" : "" }} 
            type="{{$type}}" 
            {{ $switch ? "checked" : "" }}
            {{ $required }} 
            {{ $readonly }} />
        @if($label || !$slot->isEmpty())
            <label class="switch__label" for="{{ $id}}">{!! $label ?? $slot !!}</label>
        @endif
        @if ($hint)
            <p class="form-hint">{{ $hint }}</p>
        @endif
    </div>
</x-bs-form.group>