@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'name' => null,
    'label' => null,
    'value' => null,
    'bsblockindex' => '',
    'fields' => 'alt',
    'hint' => '',
    'textareas' => '',
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'input',
        ]);

    if(!empty($value) && is_string($value))
        $value = json_decode($value, true);

    if(empty($value))
        $value = [];

        /*
    if(!isset($value[0]['id']) || empty($value[0]['id']) )
    {
        $defaultmedia = \App\Models\MediaManager::defaultImage();
        $value[0]=[];
        $value[0]['id'] = $defaultmedia->id;
        $value[0]['alt'] = basename($defaultmedia->bestPath());
    }*/

    $blank=[];
    $blank['id'] = 0;
    $blank['alt'] = '';
    
@endphp

<x-bs-form.group class="{{ $group['class'] }}">
    @if(!empty($label))
        <x-bs-form.label 
            label="{{ $label }}" 
        />
    @endif
    <x-bs-form.hint class="mt-0 mb-2">
        {{ $hint }}
    </x-bs-form.hint>
    <div class="bs4MultipleMediaEdit w-full">
        <div class="sr-only">
            <input style="width:100%;font-size:80%;border-radius:0.2em;" type='text' @if($id) id="{{ $id }}" @endif @if($name) name="{{ $name }}" @endif value="{{ json_encode($value) }}" />
        </div>
        <div class="gallery">
            @foreach($value as $image)
                <x-bs-form.media-item
                    bsblockindex="{{ $bsblockindex }}"
                    fields="{{ $fields }}" 
                    textareas="{{ $textareas }}"
                    label=""
                    overlay="1"
                    placeholder="" 
                    type="text" 
                    :value="$image"
                />
            @endforeach
            <div class="sr-only" data-role="blank-media-item">
                <x-bs-form.media-item
                    bsblockindex="{{ $bsblockindex }}"
                    fields="{{ $fields }}" 
                    textareas="{{ $textareas }}"
                    label=""
                    overlay="1"
                    placeholder="" 
                    type="text" 
                />
            </div>
            <button class="media-placeholder" type="button" data-action="add-media">
                <div class="media-placeholder__inner">
                    <x-bs-featured-icon 
                        data-action="add-media"
                        icon="image-add"
                        size="md"
                        theme="success"
                        variant="circle"
                    />
                    <p class="mt-1 text-sm text-body-tertiary">Add new image</p>
                </div>
            </button>
        </div>
    </div>
</x-bs-form.group>