@props([
    'id' => null,
    'value' => [],
    'bsblockindex' => '',
    'overlay' => 0,
    'fields' => 'alt',
    'textareas' => '',
])

@php
    //set a default image
    if(!isset($value) || empty($value))
        $value=[];

    if(empty($bsblockindex) && is_string($value))
        $value=json_decode($value, true);

    if(is_string($value))
        $value=[];

    $showImg=true;
    if(!isset($value['id']))
    {
        $showImg=false;
        $url='';

        //$defaultmedia = \App\Models\MediaManager::defaultImage();
        $value['id'] = 0; //$defaultmedia->id;
        $value['alt'] = ''; //basename($defaultmedia->bestPath());
    }

    if (empty($value['id'])) 
    {
        $showImg=false;
        $url='';

        //$defaultmedia = \App\Models\MediaManager::defaultImage();
        $value['id'] = 0; //$defaultmedia->id;
        $value['alt'] = ''; //basename($defaultmedia->bestPath());
    }

    if($showImg)
        $url = \App\Models\MediaManager::getMediaItem(@$value['id'])->thumbnailUrl();

    //fields alt is hardcoded
    $realfields = [];
    foreach( explode(',',$fields) as $item)
    {   //tidy them up
        $tr = trim($item);
        if(!empty($tr) && $tr!='alt')
            $realfields[]=$tr;
    }

    $realtextareas=[];
    foreach(explode(',',$textareas) as $item)
    {   //tidy them up
        $tr = trim($item);
        if(!empty($tr) && $tr!='alt')
            $realtextareas[]=$tr;
    }

@endphp

<div class="media-item bs4SingleMediaEdit bs4BlockSubItem bs4MediaItem" 
     data-overlay="true"
     data-role="bs4SingleMediaEdit"
     data-blockindex="{{ $bsblockindex }}">
    @if(empty($bsblockindex))                
        {{-- not in use in a block editor so it needs it's own json field--}}
        <input type="hidden" id="{{ $id }}" {{ $attributes }} value="{{ json_encode($value) }}" />
    @endif
    <div class="media-item__inner">
        <img class="media-item__preview" 
             bsblockindex="{{ $bsblockindex }}" 
             data-uid="{{ uniqid('bs4img',true) }}" 
             data-json-name="id" 
             value="{{ @$value['id'] }}" 
             src="{{ $url }}" 
             alt="{{ @$value['alt'] }}" />
        @if(!$showImg)
            <div class="media-placeholder__inner">
                    <x-bs-featured-icon 
                        data-action="add-media"
                        icon="image-add"
                        size="lg"
                        theme="primary"
                        variant="circle"
                    />
            </div>
        @endif
    </div>
    @if(boolval($overlay))
        <div class="media-item__overlay">
            <x-bs-action
                data-action="move-media-backwards"
                icon="arrow-left"
                size="sm"
                theme="secondary"
            />
            <x-bs-action
                data-action="delete-media"
                icon="delete"
                size="sm"
                theme="secondary"
            />
            <x-bs-action
                data-action="move-media-forwards"
                icon="arrow-right"
                size="sm"
                theme="secondary"
                type="button" 
            />
        </div>
    @endif            
    @foreach ($realfields as $aField)
        @php( $fieldname = strtolower(str_replace(' ','',$aField)) )
        <span 
            class="bs4MediaItem__field" 
            bsblockindex="{{ $bsblockindex }}" 
            data-json-name="{{ $fieldname }}" 
            data-label="{{ $aField }}"
            @if(in_array($aField, $realtextareas)) data-fieldtype="textarea" @endif
            value="{{ @$value[$fieldname] }}"
        >
        </span>
    @endforeach
</div>