@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'hint' => null,
    'label' => null,
    'maxlength' => 190,
    'required' => '',
    'text' => null,
    'type' => 'text',
    'value' => '',
    'fieldwidth' => null
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'input'
        ]);
@endphp

@if (!empty($text))
    <x-bs-form.group class="{{ $group['class'] }}" data-character-count="true" :width=$fieldwidth>
        @if (!empty($label))
            <x-bs-form.label
                for="{{ $id }}"
                :label=$label 
            />
        @endif
        <x-bs-form.hint class="mt-0 mb-2">
            {{ $hint }}
        </x-bs-form.hint>
        <div class="form-text">
            {{ $text }}
        </div>        
        <input 
            {{ $attributes }} 
            value="{{ $value }}"
            id="{{ $id }}" 
            type="{{ $type }}" 
            {{ $required }}
            maxlength="{{ $maxlength }}"
        />
        <x-bs-form.hint>
            <span data-role="remaining-characters">{{ $maxlength - Str::length($value) }}</span> characters remaining
        </x-bs-form.hint>
    </x-bs-form.group>
@else
    <x-bs-form.group class="{{ $group['class'] }}" data-character-count="true" :width=$fieldwidth>
        @if (!empty($label))
            <x-bs-form.label
                for="{{ $id }}"
                :label=$label 
            />
        @endif
        <x-bs-form.hint class="mt-0 mb-2">
            {{ $hint }}
        </x-bs-form.hint>
        <input 
            {{ $attributes }} 
            id="{{ $id }}" 
            value="{{ $value }}"
            type="{{ $type }}" 
            {{ $required }} 
            maxlength="{{ $maxlength }}"
        />
        <x-bs-form.hint>
            <span data-role="remaining-characters">{{ $maxlength - Str::length($value) }}</span> characters remaining
        </x-bs-form.hint>
    </x-bs-form.group>
@endif