@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'options' => [],
    'type' => 'text',
    'firstoption' => '',
    'selected' => '',
    'required' => '',
    'hint' => '',
])

@php
    $attributes = $attributes->class([
        'select',
    ])->merge([
    ]);
@endphp
<x-bs-form.group class="{{ $group['class'] }}">
    <x-bs-form.label :label=$label :for="$id" :hint=$hint />
    <input {{ $required }}  type="{{ $type }}" {{ $attributes }} {{ $id  ? "id=$id" : "" }} list="bs4-datalist-{{ $id ?? $attributes->name }}" value="{{ $selected }}" />
    <datalist id="bs4-datalist-{{ $id ?? $attributes->name }}">
        @foreach ($options as $value => $label)
            <option value="{{$value}}" {{ ($selected==$value) ? 'selected' : '' }} {{($loop->first) ? $firstoption : ""}}>
                {{ $label }}
            </option>
        @endforeach
    </datalist>
</x-bs-form-group>