@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'options' => [],
    'firstoption' => '',
    'clientId' => null,
    'value' => [],
])

@php
    $attributes = $attributes->class([
        'select',
    ])->merge([
    ]);

    $typeOptions = [
        '1' => 'Shipping Address',
        '2' => 'Billing Address',
        '3' => 'Shipping & Billing Address',
        ];
@endphp
<x-bs-form.group class="{{ $group['class'] }}">
    <x-bs-form.label :label=$label :for="$id" />
    <input {{ $id  ? "id=$id name=$id" : "" }} type='text' value="{{ $value }}" /> <!--  this field will be type="hidden" after debugging -->
    <p><small>{{ json_encode($value) }}</small></p>
    <select {{ $attributes }}  bs4address>
        @foreach ($options as $value => $label)
            <option value="{{$value}}" {{($loop->first) ? $firstoption." selected" : ""}}>
                {{ $label }}
            </option>
        @endforeach
    </select>
    <x-bs-modal id="add-{{$id}}-modal" size="xl">
    <x-bs-modal.window>
        <x-bs-modal.header
            direction="row"
            :icon="[
                'icon' => 'plus-circle',
                'theme' => 'primary'
            ]"
            title="Add a new address"
        />
        <x-bs-modal.content>
            <form>
            <x-bs-form.select required id="type" name="type" label="Address Type" 
                                        placeholder="" :options="$typeOptions"  :selected="1" />
            <x-bs-form.input required id="client_id" name="client_id" placeholder="" type="hidden" value="{{ $clientId }}" />
            <x-bs-form.input-counted required id="address_shortname" name="address_shortname" label="address_shortname" placeholder="" type="text" value="New Address {{ uniqid('#') }}" />
            <x-bs-form.input-counted required id="name" name="name" label="name" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="email" name="email" label="email" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="address_1" name="address_1" label="Address 1" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="address_2" name="address_2" label="Address 2" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="address_3" name="address_3" label="Address 3" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="city" name="city" label="City" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="region" name="region" label="Region" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="country" name="country" label="Country" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="postcode" name="postcode" label="Postcode" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="phone_1" name="phone_1" label="Phone 1" placeholder="" type="text" value="1" />
            <x-bs-form.input-counted required id="phone_2" name="phone_2" label="Phone 2" placeholder="" type="text" value="1" />

                <!--
                $table->integer('type')->default(3);
                $table->unsignedBigInteger('client_id')->nullable();

                $table->String('address_shortname');
                $table->String('name')->nullable();
                $table->String('email')->nullable();
                $table->String('address_1')->nullable();
                $table->String('address_2')->nullable();
                $table->String('address_3')->nullable();
                $table->String('city')->nullable();
                $table->String('region')->nullable();
                $table->String('country')->nullable();
                $table->String('postcode')->nullable();
                $table->String('phone_1')->nullable();
                $table->String('phone_2')->nullable();
                $table->integer('active')->default(1);
                $table->timestamps();
                -->
            </form>
            <x-bs-modal.footer-yesno />
        </x-bs-modal.content>
    </x-bs-modal.window>
</x-bs-modal>
<x-bs-modal.add-folder />

</x-bs-form-group>