@props([
    'folder' => 'misc',
    'filerequirements' => ['PDF, DOC, DOCX, XLS, XLSX, ODT, ODS', 'image/png, image/jpeg, image/webp, .pdf, .doc, .docx, .xls, .xlsx, .odt, .ods'],
])

@php
    $attributes = $attributes->class([
        'media',
    ])->merge([
    ]);
@endphp

<x-bs-tabs data-view="modal" id="media-tabs">
    <x-bs-tabs.nav>
        <x-bs-tabs.nav-item controls="modal-media-library" label="Library" selected="true" />
        <x-bs-tabs.nav-item controls="modal-media-upload" label="Upload" selected="false" />
    </x-bs-tabs.nav>

    <x-bs-tabs.panel id="modal-media-upload" selected="false">
        <div class="px-6 py-8">
            <x-bs-form.dropzone class="sr-only" icon="upload" id="media-upload" 
                    data-folder="{{ $folder }}" requirements="{{ $filerequirements[0] }}" accept="{{ $filerequirements[1] }}"/>
            <div class="mt-6 md:mt-8" data-role="file-queue">
                <div id="hiddenFileQueueItem" class="sr-only"> {{-- so thatJavaScript can duplicate the object for uploads --}}
                    <x-bs-file-queue.item />
                </div>
            </div>
        </div>
    </x-bs-tabs.panel>
    
    <x-bs-tabs.panel id="modal-media-library" selected="true">        
        <div {{ $attributes }} data-view="modal">
            <div class="media__library">
                @php
                    $dirs = \App\Models\MediaManager::getUploadDirectories('Select a folder', 'Create new folder', $folder);
                @endphp
                <x-bs-form.select 
                    class="mb-6" 
                    id="uploadDirectory" 
                    data-folder="{{ $folder }}" 
                    label="Select a folder for `{{ $folder }}`" 
                    :options="$dirs" 
                    firstoption="readonly disabled selected" 
                />
                <div class="media__library-items" data-role="media-items">
                </div>
            </div>
            <div class="media__sidebar" {{ $attributes }}>
                <div class="media__sidebar-section">
                    <p class="font-medium text-sm text-gray-700" data-role="sidebar-file-name" data-sidebar-file-name>file-name.jpg</p>
                    <p class="font-regular mt-1 text-sm text-gray-600">Size: <span data-role="sidebar-file-size" data-sidebar-file-size>0 Mb</span></p>
                </div>
                <div class="media__sidebar-section">
                    <x-bs-form.input data-dialog-id="title" label="Title"/>
                </div>
                <div class="media__sidebar-section">
                    <x-bs-button 
                        text="Update file"
                        theme="primary"
                        type="button"
                        data-a11y-dialog-hide="save-file"
                    />
                    <x-bs-button 
                        text="Cancel"
                        theme="secondary"
                        type="button"
                        data-a11y-dialog-hide
                    />
                </div>
            </div>
        </div>
    </x-bs-tabs.panel>
    <x-bs-modal.file-confirm-delete />
</x-bs-tabs>