@props([
    'icon' => null,
    'size' => 'md',
    'theme' => 'primary',
    'variant' => 'circle',
])

@php
    $attributes = $attributes
        ->merge([
            'data-size' => $size,
            'data-theme' => $theme,
            'data-variant' => $variant,
        ])
        ->class([
            'featured-icon'
        ]);
@endphp


@if($icon || !$slot->isEmpty())
    <div {{ $attributes }}>
        <x-bs-icon 
            icon="{{ $icon }}" 
        />
    </div>
@endif