@props([
    'heading' => 'Chart heading',
    'data' => null,
    'x' => [
        'label' => 'x',
    ],
    'y' => [
        'label' => 'y',
        'min' => 0,
        'max' =>1,
        //'steps' => 4 //hardcoded as 4
    ]
])

@php
    $attributes = $attributes
        ->merge([
            'data-label-x' => !empty($x['label']) ? 'true' : 'false',
            'data-label-y' => !empty($y['label']) ? 'true' : 'false'
        ])
        ->class([
            'chart'
        ]);

    if(!isset($y['min']))
        $y['min']=0;
    if(!isset($y['min']))
        $y['max']=1;
    if(!isset($y['min']))
        $y['steps']=4;

    if($data==null)
    {
        //dummy data
        $data = [
            1=>0.1,
            2=>0.5,
            3=>0.7,
            4=>0.5,
            5=>0.1
            ];
    }
@endphp

{{--  FRONT END TO DO ADD Y AXIS LABELS FROM $y['min'], $y['max'],  --}}

<table {{ $attributes }}>
    @if (!empty($x['label']))
        <caption class="chart__axis-label" data-axis="x">{{ $x['label'] }}</caption>
    @endif
    <tbody class="chart__body">
        @foreach($data as $key=>$point)
        <tr class="chart__point">
            <th class="chart__point-label">{{ $key }}</th>
            <td class="chart__point-data" style="--size:{{ $point }};"></td>
        </tr>
        @endforeach
    </tbody>
    @if (!empty($y['label']))
        <caption class="chart__axis-label" data-axis="y">{{ $y['label']}}</caption>
    @endif
</table>