@props([
    'disabled' => false,
    'icon' => null,
    'iconPosition' => 'start',
    'outline' => false,
    'size' => 'lg',
    'text' => null,
    'theme' => 'primary',
    'type' => null
])

@php
    $attributes = $attributes
        ->merge([
            'data-icon-only' => $iconPosition === 'only' ? 'true' : 'false',
            'data-outline' => $outline,
            'data-size' => $size,
            'data-theme' => $theme
        ])
        ->class([
            'button'
        ]);
@endphp

@if (!empty($type))
    <button {{ $attributes }} type="{{ $type }}" {{ $disabled ?? false ? 'disabled aria-disabled=true' : '' }}>
        @if ($icon && ($iconPosition === 'start' || $iconPosition === 'only'))
            <x-bs-icon 
                icon="{{ $icon }}" 
            />
        @endif
        {{ $text ?? $slot }}
        @if ($icon && $iconPosition === 'end')
            <x-bs-icon 
                icon="{{ $icon }}" 
            />
        @endif
    </button>
@else
    <a {{ $attributes }} {{ $disabled ?? false ? 'aria-disabled=true' : '' }}>
        @if ($icon && ($iconPosition === 'start' || $iconPosition === 'only'))
            <x-bs-icon 
                icon="{{ $icon }}" 
            />
        @endif
        {{ $text ?? $slot }}
        @if ($icon && $iconPosition === 'end')
            <x-bs-icon 
                icon="{{ $icon }}" 
            />
        @endif
    </a>
@endif