@props([
    'current' => false,
    'href' => null,
    'icon' => null,
    'text' => null
])

@php
    $attributes = $attributes
        ->merge([
            'href' => $href
        ])
        ->class([
            'breadcrumbs__link'
        ]);
@endphp

@if (!empty($icon) || !empty($text))
    <a {{ $attributes }}>
        @if ($icon)
            <x-bs-icon
                :icon=$icon
                size="xs"
            />
        @elseif ($text)
            {!! $text !!}
        @endif
    </a>
@endif