@props(
    [
        'item' => null,
        'parentblock' => null
    ]
)
@if($parentblock->hasBlocks(@$item)) {{-- technically we already checked this, we may take it out --}}
@php
    $editor_uuid = \Clevercherry\Backslash4\backslash4::generateShortUuid(12);
@endphp

<div class="px-4 py-5 md:p-6" id="sub-editor-{{ $editor_uuid }}">
    <h3 class="font-medium text-body text-lg">Sub blocks</h3>
    <p class="mt-1 text-sm text-body-tertiary">Add content blocks within this container block.</p>
    <x-bs-blocks nested="true">
        @foreach($parentblock->getAllBlocks() as $block)
            @include('backslash4::components.bs-blocks.blockeditor-row', 
                        ['item' => $parentblock, 'parentitem' => $item, 'editor_uuid_suffix' => '-'.$editor_uuid])
        @endforeach
        @if($parentblock->canAddBlocks())
            <button class="blocks__item" type="button" data-action="add-block" data-a11y-dialog-show="add-block-{{ $editor_uuid }}" data-uid="{{ uniqid('bs4rowadd',true) }}">
                <span class="action" data-size="sm" data-theme="primary-muted">
                    <x-bs-icon 
                        icon="plus" 
                        size="sm"
                    />
                </span>
                <p class="blocks__title">Add new block</p>
            </button>
        @endif
    </x-bs-blocks>

    <x-bs-modal  id="delete-block-{{ $editor_uuid }}" data-role="delete-block" size="sm">
        <x-bs-modal.header
            :icon="[
                'icon' => 'trash',
                'shape' => 'circle-outline',
                'theme' => 'error'
            ]"
            title="Delete block"
            text="Are you sure you want to delete this block? This action cannot be undone."
        />
        <x-bs-modal.actions>
            <x-bs-button
                size="lg"
                text="Cancel"
                theme="secondary"
                type="button"
                data-a11y-dialog-hide
                aria-label="Close dialog"
            />
            <x-bs-button 
                size="lg"
                text="Delete"
                theme="error"
                type="button" 
                data-action="delete-block" 
                data-a11y-dialog-hide data-action="delete-block"
            />
        </x-bs-modal.actions>
    </x-bs-modal>

    <x-bs-modal id="add-block-{{ $editor_uuid }}" data-role="add-block" size="lg">
        <x-bs-modal.header
            direction="row"
            :icon="[
                'icon' => 'plus-circle',
                'theme' => 'primary'
            ]"
            title="Add sub block"
            text="Add a new sub-block indide this block."
        />
        <x-bs-modal.content>
            <x-bs-tag-list data-role="add-block-tag-list">
                @php
                    $blocks = $parentblock->getAddableBlockNames($parentblock, @$item);
                @endphp
                @foreach($blocks as $b )
                    <x-bs-tag
                        data-for-editor="sub-editor-{{ $editor_uuid }}"
                        data-a11y-dialog-hide
                        data-new-block="{{ $b }}"
                        label="{{ Str::headline(substr($b, strpos($b, '.') + 1)) }}"
                        type="button"
                    />
                @endforeach
            </x-bs-tag-list>
        </x-modal.content>
    </x-bs-modal>
    <div class="bg-primary-50 p-4 rounded-md">
</div>
@endif