@if($item->hasBlocks())
<div class="bs4BlockEditor">
    <h2 class="font-medium mt-8 text-body text-lg">Content blocks</h2>
    <p class="mt-1 text-sm text-body-tertiary">Add blocks to populate your page with content.</p>
    <div class="blocks">
        @foreach($item->getAllBlocks() as $block)
            @include('backslash4::components.bs-blocks.blockeditor-row', ['item' => $item])
        @endforeach
        @if($item->canAddBlocks())
            <button class="blocks__item" type="button" data-action="add-block" data-a11y-dialog-show="add-block" data-uid="{{ uniqid('bs4rowadd',true) }}">
                <span class="action" data-size="sm" data-theme="primary-muted">
                    <x-bs-icon 
                        icon="plus" 
                        size="sm"
                    />
                </span>
                <p class="blocks__title">Add new block</p>
            </button>
        @endif
    </div>
</div>

<x-bs-modal id="delete-block" data-role="delete-block" size="sm">
    <x-bs-modal.header
        :icon="[
            'icon' => 'trash',
            'shape' => 'circle-outline',
            'theme' => 'error'
        ]"
        title="Delete block"
        text="Are you sure you want to delete this block? This action cannot be undone."
    />
    <x-bs-modal.actions>
        <x-bs-button
            size="lg"
            text="Cancel"
            theme="secondary"
            type="button"
            data-a11y-dialog-hide
            aria-label="Close dialog"
        />
        <x-bs-button 
            size="lg"
            text="Delete"
            theme="error"
            type="button" 
            data-action="delete-block" 
            data-a11y-dialog-hide
            @click="
                $dispatch('alert', {
                    type: 'error',
                    title: 'Block deleted',
                    message: 'This has been deleted from the page.',
                })
            "
        />
    </x-bs-modal.actions>
</x-bs-modal>

<x-bs-modal id="add-block" data-role="add-block" size="lg">
    <x-bs-modal.header
        direction="row"
        :icon="[
            'icon' => 'plus-square',
            'theme' => 'primary'
        ]"
        title="Add block"
        text="Add a new content block to this page."
    />
    <x-bs-modal.content>
        <x-bs-tag-list data-role="add-block-tag-list">
            @php
                if(isset($item))
                    $blocks = $item->getAddableBlockNames();
                else //though theoretically this should never be called this was the prior usage
                    $blocks =  App\Models\Block::getBlockNames(@$item);
            @endphp
            @foreach($blocks as $block )
                <x-bs-tag
                    data-a11y-dialog-hide
                    data-new-block="{{ $block }}"
                    label="{{ ucwords(str_replace('-', ' ', $block)) }}"
                    type="button"
                />
            @endforeach
        </x-bs-tag-list>
    </x-modal.content>
</x-bs-modal>

{{-- <x-bs-modal.library-modal /> provided in the generic editor in case it also has media and we don't want it twice --}}
@endif