<details class="blocks__item" data-expanded="false" data-id="{{ $block->id }}" data-uid="{{ uniqid('bs4row',true) }}">
    <summary class="blocks__header">
        <x-bs-dropdown positionX="left" width="4rem">
            <x-bs-action
                data-role="block-order"
                :dropdown=true
                size="sm"
                title="Move block to position"
                theme="primary-muted"
            />
            <x-bs-dropdown.menu>
                <x-bs-menu>
                    <x-bs-menu.group data-role="block-count">
                    </x-bs-menu.group>
                </x-bs-list>
            </x-bs-dropdown.menu>
        </x-bs-dropdown>
        <p class="blocks__title">{{ $block->getNameTitle() }}</p>
        <div class="blocks__actions">
            @if((!isset($item) ||  $item->canMoveBlocks()) && $block->canMoveBlock(@$item))
                <x-bs-action
                    data-action="move-block-up"
                    icon="arrow-up"
                    size="sm"
                    theme="secondary"
                    title="Move block up"
                >
                    <span class="sr-only">Move block up</span>
                </x-bs-action>
                <x-bs-action
                    data-action="move-block-down"
                    icon="arrow-down"
                    size="sm"
                    theme="secondary"
                    title="Move block down"
                >
                    <span class="sr-only">Move block down</span>
                </x-bs-action>
            @endif
            @if(!isset($item) || $item->showBlockActions())
                <x-bs-dropdown positionX="right" positionY="bottom" width="10rem">
                    <x-bs-action
                        :dropdown=true
                        icon="more"
                        size="sm"
                        theme="secondary"
                        title="Block options"
                    >
                        <span class="sr-only">Block options</span>
                    </x-bs-action>
                    <x-bs-dropdown.menu>
                        <x-bs-menu>
                            <x-bs-menu.group>
                                <x-bs-menu.item title="Add new block" type="button" data-id="{{$block->id}}" data-action="add-block" data-a11y-dialog-show="add-block{{ @$editor_uuid_suffix }}">
                                    Add block
                                </x-bs-list.item>
                                @if($block->canDeleteBlock(@$item))
                                    <x-bs-menu.item title="Delete block" type="button" data-id="{{$block->id}}" data-action="delete-block-modal" data-a11y-dialog-show="delete-block" data-block-name="{{ $block->getNameTitle() }}">
                                        Delete
                                    </x-bs-list.item>
                                @endif
                            </x-bs-list.group>
                        </x-bs-list>
                    </x-bs-dropdown.menu>
                </x-bs-dropdown>
            @endif
        </div>
    </summary>
    <div class="blocks__content">
        <input class="sr-only" name='blocks[]' type="text" value="{{ $block->stringify() }}" />
        @php( $readonly = $block->blockSwitchIsReadOnly() ? 'readonly' : '' )
        <x-bs-form.switch
            data-block-active
            id="{{ uniqid('bs4row',true) }}"
            value="1" 
            label="Block active" 
            switch="{{ ($block->active == 1) }}"
            hint="If unchecked, this block won't be visible to the public."
            readonly="{{ $block->blockSwitchIsReadOnly() ? 'readonly' : '' }}" 
        />
        
        @if(!empty(config('backslash4.tenants-on',0)))
            @includeFirst([
                \Clevercherry\Backslash4\Backslash4::getTenantNamespace().'::components.blocks-editable.'.$block->type,
                'components.blocks-editable.'.$block->type,
                'backslash4::components.blocks-editable.'.$block->type,
                'backslash4::components.blocks-editable.no-block-found'])
        @else
            @includeFirst(['components.blocks-editable.'.$block->type,
                'backslash4::components.blocks-editable.'.$block->type,
                'backslash4::components.blocks-editable.no-block-found'])
        @endif
    </div>
    @if($block->hasBlocks(@$item))
        <x-bs-blocks.sub-editor :item=@$item :parentblock=$block />
    @endif
</details>