@props([
    'icon' => [
        'position' => 'start',
        'icon' => null
    ],
    'text' =>  null,
    'size' => 'md',
    'theme' => 'primary',
])

@php
    $attributes = $attributes
        ->merge([
            'data-theme' => $theme
        ])
        ->class([
            'badge'
        ]);
@endphp

@if ($text || !$slot->isEmpty())
    <span {{ $attributes }}>
        @if (!empty($icon['icon']) && $icon['position'] === 'start')
            <x-bs-icon
                :icon="$icon['icon']"
                size="xs"
            />
        @endif
        <span class="badge__label">
            {{ $text ?? $slot }}
        </span>
        @if (!empty($icon['icon']) && $icon['position'] === 'end')
            <x-bs-icon
                :icon="$icon['icon']"
                size="xs"
            />
        @endif        
    </span>    
@endif