@props([
    'name' => null,
    'size' => null,
    'theme' => null,
    'variant' => 'circle'
])

@php
    $attributes = $attributes
        ->merge([
        ])
        ->class([
            'alert__icon'
        ]);

    // Set a default icon based on the alert theme if the name prop is empty
    if (empty($name)) {
        switch ($theme) {
            case 'infirmation':
                $name = 'warning';
                break;
            case 'warning':
                $name = 'warning';
                break;
            case 'error':
                $name = 'alert-circle';
                break;
            case 'success':
                $name = 'check-circle';
                break;
        };
    };
@endphp

<div {{ $attributes }}>
    <x-bs-featured-icon 
        :icon="$name"
        :size="$size"
        :theme="$theme"
        :variant="$variant"
    />
</div>