@props([
    'fixed' => false,
    'icon' => [],
    'message' => null,
    'show' => true,
    'theme' => null,
    'title' => null
])

@php
    $icon = array_merge([
        'name' => null,
        'size' => 'md',
        'theme' => $theme,
        'variant' => 'circle'
    ], $icon);

    $attributes = $attributes
        ->merge([
            'data-fixed' => $fixed ? 'true' : 'false',
            'data-theme' => $theme,
            'x-data' => "{
                dismiss(duration = null) {
                    if (duration === null) {
                        this.show = false;
                    } else {
                        setTimeout(() => {
                            this.show = false;
                        }, duration);
                    }
                },
                show: {$show},
                toggle(alert) {
                    if (!alert.show) return false;
                
                },
            }",
            'x-show' => 'show',
            'x-transition:enter' => 'animation-fade-in',
            'x-transition:leave' => 'animation-fade-out'
        ])
        ->class([
            'alert'
        ]);
@endphp

<div {{ $attributes }}>
    <x-bs-alert.dismiss 
        title="Dismiss aert"
        @click.prevent="dismiss()"
    />
    <x-bs-alert.icon
        :icon="$icon['name']"
        :theme="$icon['theme']"
        :variant="$icon['variant']"
        :size="$icon['size']"
    />
    <x-bs-alert.content>
        @if (!empty($title))
            <h3 class="font-medium text-sm">{!! $title !!}</h3>
        @endif
        @if (!empty($message))
            <p class="text-sm">{!! $message !!}</p>
        @endif
        {{ $slot }}
    </x-bs-alert.content>
</div>