@props([
    'header' => 1
])

@php
    $attributes = $attributes
        ->merge([
            'x-data' => '{ menuOpen: false }',
            'role' => 'banner'
        ])
        ->class([
            'header'
        ])
@endphp

<header {{ $attributes }}>
    <div class="header__container">
        <a class="header__logo" href="/admin">
            <x-bs-logo />
        </a>
        @stack('admin.header.start')
        @includeFirst(['tenant::admin.header-start', 'admin.header-start', 'backslash4::admin.header-start'])
        <div class="header__content">
            <x-bs-dropdown positionX="right" positionY="bottom" width="15rem">
                <x-bs-action theme="primary-muted" dropdown="true">
                    {{ substr(@Auth::guard('admin')->user()->firstName, 0, 1) . substr(@Auth::guard('admin')->user()->lastName, 0, 1) }}
                </x-bs-action>
                <x-bs-dropdown.menu>
                    <x-bs-menu>
                        <x-bs-menu.group>
                            <x-bs-menu.item>
                                <div class="display-flex flex-col">
                                    <p class="display-block font-semi-bold text-body-secondary text-sm">{{ @Auth::guard('admin')->user()->firstName . ' ' . Auth::guard('admin')->user()->lastName }}</p>
                                    <p class="display-block font-regular text-body-tertiary text-sm">{{ @Auth::guard('admin')->user()->email }}</p>
                                </div>
                            </x-bs-list.item>
                        </x-bs-list.group>
                        <x-bs-menu.group>
                            <x-bs-menu.item>
                                <div class="display-flex flex-col">
                                    <p class="font-medium mb-1 text-body-tertiary text-sm">Theme</p>
                                    <x-bs-theme-switch />
                                </div>
                            </x-bs-list.item>
                        </x-bs-list.group>
                        <x-bs-menu.group>
                            <x-bs-menu.item
                                href="{{ route('admin.logout') }}"
                                icon="logout"
                                text="Logout"
                            />
                        </x-bs-list.group>
                    </x-bs-list>
                </x-bs-dropdown.menu>
            </x-bs-dropdown>
            <button class="header__toggle" x-on:click="$store.global.toggleMenu()"  aria-expanded="false" :aria-expanded="$store.global.menu">
                <div class="header__toggle-icon">
                    <div class="header__toggle-line"></div>
                    <div class="header__toggle-line"></div>
                    <div class="header__toggle-line"></div>
                </div>
                <span class="sr-only">Toggle navigation</span>
            </button>
        </div>
    </div>
</header>
