@props([
    'dropdown' => false,
    'icon' => null,
    'size' => 'md',
    'tag' => 'button',
    'text' => null,
    'theme' => 'primary'
])

@php
    $attributes = $attributes
        ->merge([
            'type' => 'button',
            'data-size' => $size,
            'data-theme' => $theme
        ])
        ->class([
            'action'
        ])
@endphp

<{{ $tag }} {{ $attributes }} @if ($dropdown) x-on:click="open = ! open" :aria-expanded="open" @endif>
    <x-bs-icon
        :icon=$icon
        size="xs"
    />
    {{ $text ?? $slot }}
</{{ $tag }}>