<x-bs-site sidebar="{{ false }}" header="{{ false }}">
    <div class="overflow-hidden">
        <div class="display-grid md:grid-cols-6 login-page">
            <div class="bg-white display-flex items-center md:col-span-3 xl:col-span-2">
                <form class="px-4 py-16 w-full md:px-12 lg:lx-16 xl:px-20" method="POST" action="{{ route('admin.login') }}">
                    <div class="text-gray-900">
                        <svg class="h-8" viewBox="0 0 130 80" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
                            <path d="M108.9 27.6h21c-3.4-13-12.2-22-24.2-25.8L89.2 18.4c1.2-.3 2.5-.5 3.8-.5 7.1 0 13.2 4.5 15.9 9.7ZM109 52.4a18 18 0 0 1-16 9.8c-10.8 0-19.6-10-19.6-22 0-2.4.4-4.8 1-7L55.3 52.2l.1.5A38.8 38.8 0 0 0 93 80c18.6 0 32.5-10.2 37-27.6h-21ZM66.4 10A38 38 0 0 0 39.5 0C16.5 0 0 18 0 40.1a39 39 0 0 0 29 38.6l18-18.1c-2.2 1-4.8 1.6-7.5 1.6-10.8 0-19.6-10-19.6-21.9 0-12.3 8.8-22.4 19.6-22.4 7.1 0 13.2 4.4 15.9 9.6h21c-1.9-7-5.3-12.9-10-17.4Z"/>
                        </svg>
                    </div>
                    @csrf
                    <h1 class="font-semi-bold mt-4 text-body text-2xl lg:text-3xl">Welcome back</h1>
                    <p class="mt-2 text-body-secondary">Sign in to start your session</p>
                    <x-bs-form.input 
                        name="redirect"
                        type="hidden" 
                        :value="Request()->redirect" 
                    />
                    <x-bs-form.input 
                        autocomplete="username"
                        :group="[
                            'class' => 'mt-8'
                        ]"
                        id="email" 
                        label="Email" 
                        name="email" 
                        placeholder="Email" 
                        type="email" 
                        :value="old('email')" 
                    />
                    <x-bs-form.group class="mt-4">
                        <x-bs-form.label
                            for="password"
                            label="Password"
                        />
                        <x-bs-form.input-group>
                            <x-bs-form.input 
                                autocomplete="current-password"
                                formGroup=false
                                id="password" 
                                name="password" 
                                placeholder="••••••••"
                                required 
                                type="password"
                                data-role="password-input"
                            />
                            <x-bs-button
                                iconPosition="only"
                                icon="eye"
                                size="lg"
                                theme="secondary"
                                type="button"
                                data-action="toggle-password-visiblity"
                                data-password-visible="false"
                            >
                                <span class="sr-only" data-role="button-label">Show password</span>
                            </x-bs-button>
                        </x-bs-form.input-group>
                    </x-bs.form-group>
                    <x-bs-button 
                        class="mt-6 w-full"
                        text="{{ __('Sign in') }}"
                        theme="primary"
                        type='submit'
                    />
                    @if($errors->any())
                        <x-bs-alert class="mt-8" theme="error">
                            <ul>
                                @foreach($errors->all() AS $key => $error)
                                    <li class="text-sm">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </x-bs-alert>
                    @endif
                </form>
            </div>
            <div class="display-none md:col-span-3 md:display-block md:overflow-hidden md:position-relative xl:col-span-4">
                <div class="position-absolute top-0 left-0 right-0 bottom-0">
                    <video class="h-full w-full object-cover object-center" playsinline="playsinline" autoplay="autoplay" muted="muted" loop="loop">
                    @php
                        // old 'https://cc2021.cherrytest.com/images/hero-video.webm'
                        // now hosted in Backslash Digital Ocean spaces, and can be overridden in bs4 config
                        $videoSrcWebm = config('backslash4.login.video.webm', 'https://backslash.fra1.cdn.digitaloceanspaces.com/bs4/assets/hero-login-video.webm');
                        $videoSrcMp4 = config('backslash4.login.video.mp4', 'https://backslash.fra1.cdn.digitaloceanspaces.com/bs4/assets/hero-login-video.mp4');
                    @endphp
                        <source src="{{ $videoSrcWebm }}" type="video/webm">
                        <source src="{{ $videoSrcMp4 }}" type="video/mp4">
                        Your browser does not support the video tag.
                    </video>
                </div>
                <div class="bg-gray-900 bottom-0 left-0 position-absolute right-0 top-0" style="opacity: 75%;"></div>
            </div>
        </div>
    </div>
</x-bs-site>