@php
    $sortColumn = Request()->bs4field;
    $sortOrder = Request()->bs4sort;
@endphp
<x-bs-table.head>
    <x-bs-table.row>
        @if(!in_array('name-title',$hideColumns))
            @if (in_array('name-title', ($appModel)::sortableColumns()))
                <x-bs-table.heading 
                    column="title"
                    heading="Title"
                    :sort="[
                        'field' => 'name-title',
                        'order' => (($sortOrder === 'asc') ? 'desc' : 'asc'),
                        'sorted' => (($sortColumn === 'name-title') ? 'true' : 'false')
                    ]"
                />
            @else
                <x-bs-table.heading 
                    column="title" 
                    heading="title"
                />
            @endif
        @endif
    
        @if(!in_array('author',$hideColumns) && Schema::hasColumn($tableName,'author'))
            @if (in_array('author', ($appModel)::sortableColumns()))
                <x-bs-table.heading 
                    column="author"
                    heading="Author"
                    :sort="[
                        'field' => 'author',
                        'order' => (($sortOrder === 'asc') ? 'desc' : 'asc'),
                        'sorted' => (($sortColumn === 'author') ? 'true' : 'false')
                    ]"
                />
                @else
                <x-bs-table.heading 
                    class="[ display-none lg:display-table-cell ]" 
                    column="author" 
                    heading="Author"
                />
            @endif
        @endif
    
        @if(!empty($extraColumnsA))
            @foreach($extraColumnsA as $field => $text)
                @if (in_array($field, ($appModel)::sortableColumns()))
                    <x-bs-table.heading 
                        column="{{ $field }}"
                        heading="{{ $text }}"
                        :sort="[
                            'field' => $field,
                            'order' => (($sortOrder === 'asc') ? 'desc' : 'asc'),
                            'sorted' => (($sortColumn === $field) ? 'true' : 'false')
                        ]"
                    />
                @else
                    <x-bs-table.heading
                        heading="{{ $text }}"
                    />
                @endif
            @endforeach
        @endif
        
        @if(!in_array('status',$hideColumns))
            <x-bs-table.heading 
                class="[ display-none md:display-table-cell ]" 
                column="status"
                heading="Status"
            />
        @endif
    
        @if(!in_array('updated_at',$hideColumns))
            @if (in_array('updated_at', ($appModel)::sortableColumns()))
                <x-bs-table.heading 
                    class="[ display-none lg:display-table-cell ]" 
                    column="date"
                    heading="Last updated"
                    :sort="[
                        'field' => 'updated_at',
                            'order' => (($sortOrder === 'asc') ? 'desc' : 'asc'),
                            'sorted' => (($sortColumn === 'updated_at') ? 'true' : 'false')
                    ]"
                />
            @else
                <x-bs-table.heading 
                    class="[ display-none lg:display-table-cell ]"
                    column="date"
                    heading="Last updated"
                />
            @endif
        @endif
    
        @if(!empty($extraColumnsB))
            @foreach($extraColumnsB as $field => $text)
                <x-bs-table.heading
                        column="{{ $field }}"
                        heading="{{ $text }}"
                        :sort="[
                            'field' => $field,
                            'order' => (($sortOrder === 'asc') ? 'desc' : 'asc'),
                            'sorted' => (($sortColumn === $field) ? 'true' : 'false')
                        ]"
                />
            @endforeach
        @endif
        @if((new $appModel)->orderable())
            <x-bs-table.heading
                heading="Order"
            />
        @endif
        @if(!in_array('edit',$hideColumns))
            <x-bs-table.heading data-column="edit"></x-bs-table.heading>
        @endif
    </x-bs-table.row>
</x-bs-table.head>