import { toggleAttribute } from '../helpers/toggle-attribute';

export default () => {
    const toggles = document.querySelectorAll('.tabs__nav-toggle');

    toggles.forEach((toggle) => {
        const tabs = toggle.closest('.tabs'),
              selectedItem = tabs.querySelector('.tabs__nav-item[aria-selected=true]');

        // Set the initial toggle value
        toggle.innerHTML = selectedItem.innerHTML;

        toggle.addEventListener('click', function(event) {
            event.preventDefault();
            toggleAttribute(toggle, 'aria-expanded');
        })
    })
}