import { toggleAttribute } from '../helpers/toggle-attribute';

export default () => {
  document.addEventListener('click', (event) => {
    if (event.target.matches('.tabs__nav-item')) {
        event.stopPropagation();
        event.preventDefault();
        
        let tab = event.target.closest('.tabs'),
            targetID = event.target.getAttribute('aria-controls'),
            panes = tab.querySelectorAll(':scope > .tabs__panel'),
            links = tab.querySelectorAll(':scope > .tabs__nav .tabs__nav-item');        

        if (!targetID) return false;

        panes.forEach((panel) => {
            if (panel.getAttribute('id') === targetID) {
                panel.setAttribute('data-selected', true);                
            } else {
                panel.setAttribute('data-selected', false);
            }
        })

        links.forEach((link) => {            
            if (link !== event.target) {
                link.setAttribute('aria-selected', false);                
            } else {
                let title = link.innerHTML;
                link.setAttribute('aria-selected', true);
            }
        })
    } //else bs4.log('ccdev 032 - lick not trapped in panes');
  })
}
