import { toggleAttribute } from '../helpers/toggle-attribute';

export default () => {
  const navs = document.querySelectorAll('.navigation');

  navs.forEach((nav) => {
    const toggles = nav.querySelectorAll('.navigation__item-link[data-dropdown="true"]');
  
    toggles.forEach((toggle) => {
      toggle.addEventListener('click', (event) => {
        event.preventDefault();

        toggles.forEach((item) => {
          if (item !== toggle) {            
            item.setAttribute('aria-expanded', 'false');
          }
        });
        toggleAttribute(toggle, 'aria-expanded');
      });
    })

  } )
}