/**
 * Toggle an element attribute between true and false.
 *
 * @param {HTMLElement} element element to slide
 * @param {String} attr attribute to be toggled
 */

export const toggleAttribute = (element, attr) => {
  if (!element || !attr) return false;

  const value = (element.getAttribute(attr) === 'true') ? 'false' : 'true';
  element.setAttribute(attr, value);
};