/**
 * Shows an AlpineJS alert element.
 *
 * @param {HTMLElement} alert element to slide
 * @param {HTMLElement} eventName element to slide
 * @param {HTMLElement} message element to slide
 * @param {HTMLElement} timeout element to slide
 * 
 * @param {String} attr attribute to be toggled
 */

export const showAlert = (alert, eventName, message = '', timeout = 3000) => {
    if (!alert || !eventName) return false;
    
    // Clear all existing messages from within alert
    const content = alert.querySelector('.alert__content');
    content.innerHTML = '';

    // Create a new p element and append it to the alert
    const text = document.createElement('p');
    text.classList.add('text-sm');
    text.textContent = message;
    content.appendChild(text);

    // Create a custom event and dispatch it to the alert
    const showEvent = new CustomEvent(eventName, { detail: { show: true }, bubbles: true });
    alert.dispatchEvent(showEvent);
};