//import A11yDialog from 'a11y-dialog';
import A11yDialog from "../../libs/a11y-dialog";
import { nicEditors } from '../../libs/nicedit-cc/nicEditcc.js';
import { toggleAttribute } from '../helpers/toggle-attribute';
import { resizeTextarea } from '../helpers/resize-textarea';
//import bs4 from  "../../backslash4" //now a global object

/**
 * Takes the total number of blocks within a block editor and creates a
 * numbered list.
 * 
 * @param {HTMLElement} block block editor element
 * @returns {HTMLElement} options ordered list of options
 */

const bsCreateBlockOrderList = (block) => {
    // Get relevant HTMLElements
    const blocks = Array.from(block.children).filter(child => child.classList.contains('blocks__item') && !child.hasAttribute('data-action') && child.getAttribute('data-action') !== 'add-block');

    // Create options list HTMLElement
    const options = document.createElement('div');
    options.classList.add('menu__scroll');

    // Loop through all block items in a block editor
    blocks.forEach((blockItem, index) => {
        // Create options item HTML element
        const option = document.createElement('button');
        const text = document.createElement('span');
        option.classList.add('menu__item');
        option.type = 'button';
        option.setAttribute('data-block-order', index);
        text.classList.add('menu__item-text');
        text.textContent = index + 1;
        option.appendChild(text);

        // Append new option to options list
        options.appendChild(option);
    });

    // Return options list
    return options;
}


/**
 * Updates the order lists of all block items when any block change is made.
 */

const bsUpdateBlockOrderNumber = () => {
    // Get relevant HTMLElements
    const blockEditors = document.querySelectorAll('.blocks');

    // Loop through all block editors
    blockEditors.forEach((blockEditor) => {
        // Get relevant HTMLElements
        const blocks = Array.from(blockEditor.children).filter(child => child.classList.contains('blocks__item') && !child.hasAttribute('data-action'));

        // Loop through all block elements in the block editor
        blocks.forEach((block, index) => {
            // Get relevant HTMLElements
            const order = block.querySelector('[data-role=block-order]');
            const dropdown = block.querySelector('div[data-role=block-count]');

            // Set block order attribute on block item
            block.setAttribute('data-block-order', index);

            // Set the order HTML and add 1 so the first block isn't 0.
            order.textContent = index + 1;

            const list = bsCreateBlockOrderList(blockEditor);

            // Clear the existing list and add the new one.
            dropdown.innerHTML = '';
            dropdown.appendChild(list);
        });
    });
};


/**
 * Moves a block to a new index when the order button is clicked.
 * 
 * @param {Object} event order button click event
 */

const bsClickBlockOrderButton = (event) => {
    // Prevent default button click action
    event.preventDefault();

    // Get relevant HTMLElements
    const currentBlock = event.target.closest('.blocks__item');
    const blocksContainer = currentBlock.parentElement;
    const targetBlockIndex = Number(event.target.getAttribute('data-block-order'));

    // Return if the target index is the same as the current block index
    if (targetBlockIndex === Number(currentBlock.dataset.blockOrder)) return false;

    // Get all the blocks as an array
    const siblingBlocks = Array.from(blocksContainer.querySelectorAll('.blocks__item:not([data-action=add-block])'));

    // Move the current block to the target position
    if (targetBlockIndex > Number(currentBlock.dataset.blockOrder)) {
        blocksContainer.insertBefore(currentBlock, siblingBlocks[targetBlockIndex].nextSibling);
    } else {
        blocksContainer.insertBefore(currentBlock, siblingBlocks[targetBlockIndex]);
    }

    // Update all block order numbers
    bsUpdateBlockOrderNumber();
};



/**
 * Expands a block when the expand button is clicked
 * 
 * @param {Object} event - Expand button click event
 */

const bsClickBlockExpandButton = (event) => {
    // Prevent default button click event
    event.preventDefault();    
    
    // Get relevant HTMLElements
    const targetBlock = event.target.closest('.blocks__item');
    const blocks = document.querySelectorAll('.blocks > .blocks__item:not(.blocks > [data-action=add-block])');

    blocks.forEach((block) => {
        if (block !== targetBlock) {
            block.setAttribute('data-expanded', false);
        } else {
            toggleAttribute(targetBlock, 'data-expanded');
        }
    })
}


/**
 * 
 * @param {*} event 
 */
function bsClickBlockUpButton(event)
{        
    event.preventDefault();
    var targRow = event.target.closest('.blocks__item');
    var sibling = targRow.previousElementSibling;
    sibling.before(targRow);
    bsUpdateBlockOrderNumber();
}

/**
 * 
 * @param {*} event 
 */
function bsClickBlockDownButton(event)
{
    event.preventDefault();
    var targRow = event.target.closest('.blocks__item');
    var sibling = targRow.nextElementSibling;
    sibling.after(targRow);
    bsUpdateBlockOrderNumber();
}

/**
 * 
 * @param {*} event 
 */
const bsClickBlockDeleteButton = (event) => {
    console.log('ccdev delete', event);

    let modal = document.querySelector('#delete-block');

    let uid = event.target.closest('[data-id]').dataset.id;
    console.log('ccdev 174', uid, event.target);
    modal.setAttribute('data-target-uid', uid);
    
    const dialog = new A11yDialog(modal);
    const blockName = event.target.closest('.menu__item').getAttribute('data-block-name');

    dialog.on('show', function (element, event) {
        modal.setAttribute('data-block-name', blockName);
    })
    
    dialog.on('hide', function (element, event) {
        modal.removeAttribute('data-block-name');
    })

    dialog.show();
}


/**
 * Adds a new block to the DOM.
 * 
 * @param {Element} blockLocation - the block closest to where the add button
 *                                  was triggered.
 * @param {String} blockName - the name of the new block to be added.
 */
const bsAddBlock = (blockLocation, blockName) => {
    const xhr = new XMLHttpRequest();
    xhr.onload = function() {
        if (xhr.status === 200) {
            const blocks = document.querySelector('.blocks');
            console.log('ccdev 205', blockLocation);

            let template = this.response;
            let newRow = null;

            console.log('ccdev 210 blockLocation', blockLocation);
            //console.log('ccdev 214 template', template);
            
            // if (blockLocation.classList.contains('block--add')) {
            if (blockLocation.getAttribute('data-action') == 'add-block') {
                blockLocation.insertAdjacentHTML('beforebegin', template);
                newRow = blockLocation.previousElementSibling;
            } else {                
                blockLocation.insertAdjacentHTML('afterend',template);
                newRow = blockLocation.nextElementSibling;
            }
            console.log('ccdev 222 newRow', newRow);
            var modalId = blockLocation.getAttribute('data-a11y-dialog-show');
            if(modalId==null)
                modalId= blockLocation.querySelector('[data-action=add-block]').getAttribute('data-a11y-dialog-show');
            console.log('ccdev 224 modalId', modalId);

            if((modalId!='add-block'))
            {   //we know its a sub block because the dialog is not a top level, it's one wioth a UUID attachjed 
                newRow.querySelector('button[data-action=add-block]').setAttribute('data-a11y-dialog-show', modalId);

                //also add the parent block id into the json in the imput field
                const jsoninput = newRow.querySelector('input[name="blocks[]"][type=text]');
                var value= jsoninput.value;
                console.log('ccdev 231', value);
                var obj = JSON.parse(value);
                obj.subblock=true;
                console.log('ccdev 233', obj);
                jsoninput.setAttribute('value',JSON.stringify(obj));
                console.log('ccdev 236', JSON.parse(jsoninput.value));
                
            }
            
            bsUpdateBlockOrderNumber();
            //bs4RefreshMediaBlocks();
            
            if(this.responseText.includes('richtexteditor'))
            {
                console.log('ccdev 235', newRow);
                if(newRow!=null)
                    nicEditors.byElements(newRow.querySelectorAll('textarea[richtexteditor]'));
                else //fallback
                    nicEditors.byElements(template.querySelectorAll('textarea[richtexteditor]'));
            }
            bs4AddChangeListeners();
        } else
        {
            console.log('AjaxFail 244:',  xhr.status, xhr.responseText);            
        }
        
    }

    xhr.open("GET", "/adminBS4/ajax/get-edit-block/"+ blockName, true);
    //xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded; charset=UTF-8');
    xhr.setRequestHeader('X-CSRF-TOKEN', document.querySelector('meta[name="csrf-token"]').content);  
    xhr.send();
}


/**
 * Adds a block when selected from the modal.
 * 
 * @param {*} event 
 */

const bsClickBlockAddButton = (event) => {

    console.log('ccdev 273', event.target);
    const modalId = event.target.getAttribute('data-a11y-dialog-show');
    let modal = document.getElementById(modalId);
    console.log('ccdev 277',modalId, modal);
    modal.setAttribute('data-row-uid', event.target.closest('.blocks__item').getAttribute('data-uid') );

    const dialog = new A11yDialog(modal);
    dialog.show();
}

function bs4ChangeBlockActive(event)
{
    event.preventDefault();
    event.stopPropagation();
    event.stopImmediatePropagation();
      
    console.log('ccdev 272', event.target.checked );
    var jsoninput = event.target.closest('.blocks__item').querySelectorAll("[name='blocks[]']")[0];

    var data = JSON.parse(jsoninput.value);
    
    data.active=(event.target.checked) ? 1 : 0;

    jsoninput.value  = JSON.stringify(data);
}
function bs4ClickCancelUpdateMedia(event)
{
    //most often do nothing, but we shall remove empty media items in galleries
    console.log('ccdev 288 Cancel-save-media');

    var container = event.target.closest('div.media__sidebar');
    var thumb = container.querySelector('img[data-role=sidebar-thumbnail]');
    var uid = thumb.getAttribute('data-img-uid');
    var targetimg = document.querySelector(`img[data-uid="${uid}"]`);

    console.log('ccdev 294 id=0, mme=', targetimg.closest('div.bs4MultipleMediaEdit'));
    if((targetimg.getAttribute('value')=='0') && targetimg.closest('div.bs4MultipleMediaEdit')!=null)
    {   //if it's a multiple editor remove the object that was not set -- but not if its a single image
        var imgContainer = targetimg.closest('.bs4SingleMediaEdit');
        imgContainer.remove();
    }    
}
function bs4ClickResetMedia(event)
{
    console.log('ccdev 303');
    var container = event.target.closest('div.media__sidebar');
    var thumb = container.querySelector('img[data-role=sidebar-thumbnail]');
    var uid = thumb.getAttribute('data-img-uid');
    var targetimg = document.querySelector(`img[data-uid="${uid}"]`);
    if(targetimg!=null)
    {
      targetimg.src = '';
      targetimg.setAttribute('value', -1);
      var targetMedia = targetimg.closest('div.bs4MediaItem');
      console.log('ccdev 314', targetimg)

      var imgContainer = targetimg.closest("div.media-item__inner");
      console.log('ccdev 317', imgContainer);
      console.log('ccdev 318', imgContainer.querySelector('div[data-action=add-media]'));
      imgContainer.querySelector('div[data-action=add-media]').classList.remove('sr-only');
      
      container.querySelectorAll(`input[data-dialog-id]`).forEach(item => {
        //var alt = container.querySelector(`input[data-dialog-id="alt"]`).value;
        var jsonName = item.getAttribute('data-dialog-id');
        var targetField = targetMedia.querySelector(`[data-json-name="${jsonName}"]`);
        if(targetField!=null)
        {
            targetField.setAttribute('value','');
        }
        if(jsonName=='alt')
        {   targetimg.setAttribute('alt', ''); 
        }
      });
      container.querySelectorAll(`textarea[data-dialog-id]`).forEach(item => {
        //var alt = container.querySelector(`input[data-dialog-id="alt"]`).value;
        var jsonName = item.getAttribute('data-dialog-id');
        var targetField = targetMedia.querySelector(`[data-json-name="${jsonName}"]`);
        if(targetField!=null)
        {
            targetField.setAttribute('value','');
        }
      });

      bs4DataJsonNameUpdate(targetimg);
    }
}
function bs4ClickUpdateMedia(event)
{
    console.log('ccdev 148 save-media add click');
      console.log('ccdev 150 save-media');
      var container = event.target.closest('div.media__sidebar');
      console.log('ccdev 288 container', container);
      //var thumb = container.querySelector('img.media__sidebar-thumb');
      var thumb = container.querySelector('img[data-role=sidebar-thumbnail]');
      console.log('ccdev 290 thumb', thumb);

      var src = thumb.src;
      var id = thumb.getAttribute('data-media-id');
      var uid = thumb.getAttribute('data-img-uid');
      console.log('ccdev 293, data-img-uid', uid);

      var targetimg = document.querySelector(`img[data-uid="${uid}"]`);
      console.log('ccdev 296 targetimg',targetimg);

      if(targetimg!=null)
      {
        targetimg.src = src;
        targetimg.setAttribute('value', id); //using setAttribute becuse it's not an input field
        
        var targetMedia = targetimg.closest('div.bs4MediaItem');
        console.log('ccdev 326 targetMedia', targetMedia);
        container.querySelectorAll(`input[data-dialog-id]`).forEach(item => {
            //var alt = container.querySelector(`input[data-dialog-id="alt"]`).value;
            var jsonName = item.getAttribute('data-dialog-id');
            var targetField = targetMedia.querySelector(`[data-json-name="${jsonName}"]`);
            if(targetField!=null)
            {
                targetField.setAttribute('value', item.value);
            }
            if(jsonName=='alt')
            {   targetimg.setAttribute('alt', item.value); 
            }
        });
        container.querySelectorAll(`textarea[data-dialog-id]`).forEach(item => {
            //var alt = container.querySelector(`input[data-dialog-id="alt"]`).value;
            var jsonName = item.getAttribute('data-dialog-id');
            var targetField = targetMedia.querySelector(`[data-json-name="${jsonName}"]`);
            if(targetField!=null)
            {
                targetField.setAttribute('value', item.value);
            }
        });
        
        bs4DataJsonNameUpdate(targetimg);
      }
}
function bs4MediaFieldChange(event)
{
   var jsoninput = event.target.closest('.bs4SingleMediaEdit').querySelectorAll("[bsblockindex]")[0];
   var dataid = event.target.getAttribute('bs4MediaField');
   console.log('ccdev 118', jsoninput);
   console.log('ccdev 119', dataid);
   console.log('ccdev 120', jsoninput.value);

   var data = JSON.parse(jsoninput.value);
   console.log('ccdev 123', data);

    data[dataid]=event.target.value;

    jsoninput.value  = JSON.stringify(data);
    
    const e = new Event("change");
    jsoninput.dispatchEvent(e);
}
function bs4SubItemChange(event)
{
    var subfield = event.target.getAttribute('data-json-name');
    if(subfield!=null && subfield!='')
    {   
        console.log('ccdev 161', subfield);
        var componentjson = event.target.closest('div.bs4BlockSubItem').querySelector('input[bsblockindex]');
        if(componentjson!=null)
        {
            var data = JSON.parse(componentjson.value);
            var val = event.target.value;
            if(bs4.hasJsonStructure(val))
            { data[subfield]=JSON.parse(val);
            } else
            { data[subfield]=val;
            }
            componentjson.value  = JSON.stringify(data);
            componentjson.dispatchEvent(new Event('change'));
        }
    }
}
function bs4BlockdataChange(event)
{
    bs4.log('ccdev 437', event.target.name, event.target.value );
    var jsoninput = event.target.closest('.blocks__content').querySelectorAll("[name='blocks[]']")[0];
    var dataid = event.target.getAttribute('bsblockindex');
    var data = JSON.parse(jsoninput.value);    

    //just this single input item changing
    //console.log('ccdev 216', jsoninput.value);
    //console.log('ccdev 217', dataid);

    if (!(dataid in data))
        data[dataid]={};
    
    // This is probably very messy and can be done better
    var val = '';
    
    if (event.target.getAttribute('type') == 'checkbox') {
        if (event.target.checked) {
            event.target.value = 1;
            val = 1;
        } else {
            event.target.value = 0;
            val = 0;
        }
    } else {
        val = event.target.value;
    }

    
    if(bs4.hasJsonStructure(val))
    { data[dataid].data=JSON.parse(event.target.value);
    } else
    { data[dataid].data=event.target.value;
    }
    
    jsoninput.value = JSON.stringify(data);    
}
function bs4DataJsonNameUpdate(target)
{
    console.log('ccdev 196', target );
    var block = target.closest('.blocks__content');
    if(block==null)
    { //this is a non block image
        block = target.closest('div.bs4MultipleMediaEdit');

        if(block==null)
            block = target.closest('div.bs4SingleMediaEdit');
    }
    console.log('ccdev 202 closest container', block);
    
    var jsoninput = block.querySelector("[name='blocks[]']");
    if(jsoninput==null)
    { //this is a non block image
        jsoninput = block.querySelector('input');
    }
    console.log('ccdev 209 input', jsoninput );

    var dataid = target.getAttribute('bsblockindex');
    var data = JSON.parse(jsoninput.value);

    if (!(dataid in data))
        data[dataid]={};

    //test if this is a gallery of images and not just one
    var gallery=target.closest('div.bs4MultipleMediaEdit')

    var val={};
    if(gallery!=null)
    {
        //this is a gallery
        console.log('ccdev 234 is gallery', jsoninput.value);
        var val =[];
        var i=0;
        gallery.querySelectorAll('div.bs4SingleMediaEdit').forEach(item => {
                
                var iData={};
                item.querySelectorAll('[data-json-name]').forEach(json => {
                    var jname = json.getAttribute('data-json-name');

                    iData[jname] = json.getAttribute('value');
                    if(jname=='id') //this is also the image so we can get the alt tag
                        iData['alt'] = json.getAttribute('alt');

                    if(dataid==null)
                        dataid = json.getAttribute('bsblockindex');
                    
                    console.log('ccdev 473 json item', jname, iData[jname]);
                });
                
                if(iData['id']!=0)
                {   val[i] = iData;
                    i++;
                    console.log('ccdev 486 json line', iData);
                } else
                {
                    //items with id =0 in a gallery should be removed unless they are the hidden placeholder
                    console.log('ccdev 465 id=0,', iData, item.closest('div[data-role=blank-media-item]'));
                    if(item.closest('div[data-role=blank-media-item]')==null)
                        item.remove();
                }
        });
    } else
    { //just this single input item changing
          console.log('ccdev 497 single imageold data ', jsoninput.value);
          console.log('ccdev 498', dataid);
          var item = target.closest('div.bs4BlockSubItem');
          console.log('ccdev 500 jsn block', item);
          val['alt']= target.getAttribute('alt');
    
          item.querySelectorAll('[data-json-name]').forEach(json => {
                    var jname = json.getAttribute('data-json-name');
                    val[jname] = json.getAttribute('value');
          });
          console.log('ccdev 245074 single imagenew data ', val, target);
 
    }
    if(val.id==0)
    {
        //no image selected
        console.log('no image id selected');
        //click the del button if there is one
        console.log('ccdev 479', target);
        return;
    }
    console.log('ccdev 471 bsb, val', dataid, val)
    if(dataid!="")
        data[dataid].data=val;
    else
    {   //single
        data = val;

        if(val.id>0)
        {
            var addMediaBtn = block.querySelector('[data-action=add-media]');
            if(addMediaBtn!=null)
                addMediaBtn.classList.add('sr-only');
        }
    
    }
    
    console.log('ccdev 477 jsoninpuy', jsoninput);    
    console.log('ccdev 478 new data',  JSON.stringify(data));    
    jsoninput.value  = JSON.stringify(data);
    jsoninput.setAttribute('value', JSON.stringify(data));
    //show items
    target.classList.remove('sr-only');
        
    console.log('ccdev 529');
}

/**
 * 
 * 
 */

const createInput = (name, type, id) => {
    const group = document.createElement('div');
    const label = document.createElement('label');
    group.classList.add('form-group');
    label.classList.add('label');
}

function bs4MediaClickImg(event) {   
    console.log('ccdev 482', event.target);
    var targetImg = event.target;
    var targetUid = targetImg.getAttribute('data-uid');
    if((targetUid=='') || (targetUid=='null') || (targetUid==null))
    {   targetImg=event.target.querySelector('img');
        targetUid = targetImg.getAttribute('data-uid');
    }
    console.log('ccdev 484', targetImg, targetUid);
    
    var modal = document.querySelector('#media-library-modal');

    var formgroup = event.target.closest('.form-group');
    var txt = formgroup.querySelector('[bsblockindex]').value;

    var imgGroup = event.target.closest('[data-role=bs4SingleMediaEdit]');
    bs4.log('ccdev 630 imgGroup', imgGroup, imgGroup.querySelector('[type=hidden]'));

    var img = targetImg.src;
    var alt = targetImg.getAttribute('alt');
    if (event.target.classList.contains('media-field__edit')) {
        img = event.target.querySelector('img').src;
        alt = event.target.querySelector('img').getAttribute('alt');
    }

    //var thumb = modal.querySelector('img.media__sidebar-thumb');
    var thumb = modal.querySelector('img[data-role=sidebar-thumbnail]');
    var placeholder = modal.querySelector('[data-role=sidebar-placeholder]');
    console.log('ccdev 505',targetImg, targetImg.getAttribute('value'));
    if(targetImg.getAttribute('value')<=0)
    {
        console.log('ccdev 509');
        thumb.classList.add('sr-only');
        placeholder.classList.remove('sr-only');
    } else
    {
        console.log('ccdev 514');
        thumb.classList.remove('sr-only');
        placeholder.classList.add('sr-only');
    }
    thumb.src=img;
    thumb.setAttribute('data-media-id', targetImg.getAttribute('value'));
    bs4.log('ccdev 495 set data-img-uid', targetUid);
    thumb.setAttribute('data-img-uid', targetUid);
    
    let fieldname='';
    try {
        fieldname = formgroup.querySelector('input[type=hidden]').getAttribute('name');
    } catch (error) {}
    let model ='';
    try {
        model = formgroup.closest('form[data-class]').dataset.class;        
    } catch (error) {}
    bs4.log('ccdev 00650', model, fieldname);

    thumb.setAttribute('data-img-model', model);
    thumb.setAttribute('data-img-fieldname', fieldname);
    
    //modal.querySelector('[data-dialog-id="alt"]').value = formgroup.querySelector('[data-json-name="alt"]').getAttribute('value');

    //remove pre-existing extra fields in the modal
    modal.querySelectorAll('[data-dialog-id]:not([data-dialog-id="alt"])').forEach(item => {
        item.closest('.form-group').remove();
    });
    
    let altInput =  modal.querySelector('[data-dialog-id="alt"]');
    bs4.log('ccdev 679 alt:', alt, altInput);
    altInput.value = alt;

    var altForm = altInput.closest('.form-group');
    imgGroup.querySelectorAll('[data-json-name]:not([data-json-name="id"])').forEach(item => {
        var jsonName = item.getAttribute('data-json-name');
        var value = item.getAttribute('value');
        bs4.log('ccdev 686 jsonNAme, value:', jsonName, value);
        var modalTarget = modal.querySelector(`[data-dialog-id="${jsonName}"]`);

        if (modalTarget == null) {
            var newField = altForm.cloneNode(true);
            var labelName=item.getAttribute('data-label');

            if ((labelName==null) || (labelName=='')) {
                labelName = jsonName;
            }

            newField.querySelector('label').innerHTML = labelName;
            var input = newField.querySelector('input');

          if (item.getAttribute('data-fieldtype') == 'textarea') {
            var textarea = document.createElement('textarea');
            textarea.classList.add('textarea');
            textarea.setAttribute('data-resize', 'true');
            textarea.setAttribute('data-dialog-id', jsonName);
            textarea.value=value;
            input.insertAdjacentElement('afterend', textarea);
            textarea.style.height = '10px';

            setTimeout(function() {
                resizeTextarea(textarea);
            })

            textarea.addEventListener('input', (event) => {
                resizeTextarea(textarea);
            });

            input.remove();
          } else
          {
            input.setAttribute('value', value);
            input.value = value;  
            input.setAttribute('data-dialog-id',jsonName);
        }
          altForm.insertAdjacentElement('afterend',newField);
        } else
        { console.log('ccdev 597 exists', jsonName, value);
          modalTarget.value = value;
          modalTarget.setAttribute('value', value);
        }
    });

    //modal.querySelector('#uploadDirectory').value='';
    modal.querySelector('.dropzone').classList.add('sr-only');
    modal.querySelector('[data-a11y-dialog-show]').click();
}
function bs4ClickAddButton(event)
{
    event.stopImmediatePropagation();
    console.log('ccdev 565 media-add click');
        
    var image = event.target.closest('div.media-item');
    console.log('ccdev 568 image',image);
    if(image==null)
    {
        //new add placeholder thang
        var insertTarget =  event.target.closest('div.gallery').querySelector("div[data-role=blank-media-item]");
        image = insertTarget.querySelector("div.media-item");
        var newImage = image.cloneNode(true);

        var img = newImage.querySelector('img[data-uid]');
        img.setAttribute('data-uid', 'bs4img'+ Date.now().toString(16)+"."+Math.floor(Math.random() * 65536*2).toString(16));
        
        //newImage.querySelector('.media-placeholder__inner').remove();
        newImage.querySelector('.media-placeholder__inner').classList.add('sr-only');

        console.log('ccdev 29 newImage', newImage);
        insertTarget.insertAdjacentElement('beforebegin', newImage);

        //empty image item so don't update the JSON... yet
        //fire the popup
        newImage.querySelector('img').click();

    } else
    {
        var newImage = image.cloneNode(true);
        var img = newImage.querySelector('img[data-uid]');
        img.setAttribute('data-uid', 'bs4img'+ Date.now().toString(16)+"."+Math.floor(Math.random() * 65536*2).toString(16));
        console.log('ccdev 29 newImage', newImage);
        image.insertAdjacentElement('afterend', newImage);
        
        
        //bs4RefreshMediaBlocks();  
        bs4DataJsonNameUpdate(event.target);
    }    
}
function bs4ClickDelButton(event)
{
    event.stopPropagation();
    var refreshTarget = event.target.closest('div.bs4MultipleMediaEdit'); 
    var image = event.target.closest('div.media-item');
    image.remove();
    console.log('ccdev 276 del rTarget', refreshTarget);
    bs4DataJsonNameUpdate(refreshTarget);
}
function bs4ClickFwdButton(event)
{   event.stopPropagation();

    var targ = event.target.closest('div.media-item');
    console.log('ccdev 637', targ.nextElementSibling);
    if(targ.nextElementSibling.getAttribute('data-role')!='blank-media-item')
    {  var next = targ.nextElementSibling.insertAdjacentElement('afterend',targ);
        bs4DataJsonNameUpdate(targ);
    }
}
function bs4ClickBackButton(event)
{   event.stopPropagation();
    var targ = event.target.closest('div.media-item');
    console.log('ccdev 647', targ.previousElementSibling);
    if(targ.previousElementSibling!=null)
    {
        var next = targ.previousElementSibling.insertAdjacentElement('beforebegin',targ);
        bs4DataJsonNameUpdate(targ);
    }
}
function bs4AddNewBlock(event)
{
    let modal = event.target.closest('[data-a11y-dialog]');
    let targetRowUID =  modal.getAttribute('data-row-uid');
    console.log('ccdev 785', modal);
    console.log('ccdev 786 hide', targetRowUID, event.target.getAttribute('data-new-block'));
    let targetRow = document.querySelector(`[data-uid="${targetRowUID}"]`);
    console.log('ccdev 788', targetRow);

    // Pass params to add block function
    bsAddBlock(targetRow, event.target.getAttribute('data-new-block'));
}
function bs4RemoveBlock(event)
{
    let modal = event.target.closest('[data-a11y-dialog]');
    var row_uid = modal.getAttribute('data-target-uid');
    console.log('ccdev 814',row_uid);
    document.querySelector(`details[data-id="${row_uid}"]`).remove();
    bsUpdateBlockOrderNumber();
}
function bs4AddChangeListeners()
{
    //because a change event trioggered on textarea from JS does not bubble up to the document
    document.querySelectorAll('textarea[bsblockindex]').forEach(function (element){
        element.addEventListener('change', bs4BlockdataChange);
    });
}

//document.addEventListener('DOMContentLoaded', () => {
bs4.ready( () => {
    //bs4RefreshMediaBlocks();
    //bsCreateAddModal(); -- now all done with clicks below because of dynamic
    bsUpdateBlockOrderNumber();
    bs4AddChangeListeners();

    // event delegation traps for items
    document.addEventListener('change', (event) => {
        const target = event.target;

        bs4.log('ccdev 819 change', event.target);
        if (target.matches('input[bsblockindex]')) {
             bs4BlockdataChange(event);
        } else if(target.matches('[data-json-name]')) {
            bs4SubItemChange(event);
        } else if(target.matches('textarea[bsblockindex]')) {
            console.log('ccdev 787');
            bs4BlockdataChange(event);
        } else if(target.matches('select[bsblockindex]')) {
            bs4BlockdataChange(event);
        } else if(target.matches('input[bs4MediaField]')) {
            bs4MediaFieldChange(event);
        } else if(target.matches('input[type=checkbox][data-block-active]')) {
            bs4ChangeBlockActive(event);
        }
    });
    
    document.addEventListener('click', (event) => {
        const target = event.target;

        if (target.matches('[data-action=delete-block-modal]')) {
            bsClickBlockDeleteButton(event);
        } else if(target.matches('button[data-action=move-block-up]')) {
            bsClickBlockUpButton(event);
        } else if(target.matches('button[data-action=move-block-down')) {
            bsClickBlockDownButton(event);
        } else if (target.matches('button[data-action=expand-block]')) {          
            bsClickBlockExpandButton(event);
        } else if (target.matches('[data-action=add-block]')) {
            bsClickBlockAddButton(event);
        } else if(target.matches('[data-new-block]'))
        {   bs4AddNewBlock(event);
        } else if(target.matches('[data-action="delete-block"]'))
        {   bs4RemoveBlock(event);
        } else if (target.matches('button[data-block-order]')) {
            bsClickBlockOrderButton(event);
        } else if (target.matches('[data-action=add-media]')) {
            bs4ClickAddButton(event);
        } else if (target.matches('[data-action=move-media-forwards]')) {
            bs4ClickFwdButton(event);
        } else if (target.matches('[data-action=move-media-backwards]')) {
            bs4ClickBackButton(event);
        } else if (target.matches('[data-action=delete-media]')) {
            bs4ClickDelButton(event);
        } else if (target.matches('.media-item__inner') || target.matches('.media-item__preview')) {
            bs4MediaClickImg(event);
        } else if (target.matches('[data-a11y-dialog-hide=save-media]')) {
            bs4ClickUpdateMedia(event);
        } else if (target.matches('[data-a11y-dialog-hide=reset-media]')) {
            bs4ClickResetMedia(event);
        } else if (target.matches('[data-a11y-dialog-hide=cancel-save-media]')) {
            bs4ClickCancelUpdateMedia(event);
        } //else bs4.log('ccdev 871 - lick not trapped in editor');
    })
});
