<?php

namespace Clevercherry\Backslash4\Models;

class Product extends Model
{
    use scopeActive;

    /**
     * return a list of categories or types for field selection
     */
    public function getChooseOptions($field_name)
    {
        $list = [];

        if($field_name=='category')
        {   
            $list[0] = 'Select a '. $field_name;
            $cats = ProductCategory::active()->get();
            foreach($cats as $cat)
                $list[$cat->id] = $cat->name;
        } else if($field_name=='type')
        {   
            $list[0] = 'Select a '. $field_name;
            $cats = ProductType::active()->get();
            foreach($cats as $cat)
                $list[$cat->id] = $cat->name;
        }

        return $list;
    }

    public function includeInSitemap() : bool
    {
        return $this->active;
    }

    public function includeModelInSitemap() : bool
    {
        return true;
    }

    public function getShortenedDescription($length=255) : String
    {
        return self::limitHtml($this->description, $length);
    }

    /**
    * return an array widget info
    * @return Array of widget info for display on the admin dashboard
    */
    public static function getDashboardWidgets()
    {
        $widgets=[];

        // $widgets[]=['type'=>'bs-dashboard-widget.info',
        //             'heading'=>"No. of Products",
        //             'text'=> 'Active '.self::active()->count('id').'<br>'
        //                     .'All '.self::count('id'),
        //             'widget-order' => 3000
        //           ];
        return $widgets;
    }

    /**
     * Adds model description text under the main <h1> tag.
     * 
     * @return String content to be displayed under the the index page heading.
     */

    public static function getExtraIndexHeaderView()
    {
        return '<p class="mt-1 text-body-tertiary">Manage and update your avaiable products.</p>';
    }
}