<?php

namespace Clevercherry\Backslash4\Models;

class Page extends Model
{
    use scopeActive;

    /**
     * return a list of valid pick from parents -- override this function in your specific model
     * should return an index array[id]="name" for use in a select statement
     * @return Array | null      null = no parents, array for a slect statement of [value]=Title
     */
    public function getChooseParents()
    {
        $parents=[];
        
        $parents[0] = 'No parent';

        foreach( self::active()
                       ->where('id', "!=", $this->id)
                       ->where( function ($query)
                       {
                          $query->whereNull('parent')->orWhere('parent',0);
                       })
                       ->get() as $item)
        {
            $parents[$item->id] = $item->getNameTitle();
        }

        return $parents;
    }

    public function includeInSitemap() : bool
    {
        return $this->active;
    }

    public function includeModelInSitemap() : bool
    {
        return true;
    }

    /**
     * return list of this model items that are children of thsi item
     * @return Iterable
     */
    public function getChildren() : Iterable
    {
        return self::where('parent', $this->id)->get();
    }

    /**
     * whether the index page shows children under the parent items
     * the individual model should filter out the children in the first list of items to the index page
     * see getAdminListing() and scopeSearchIndex in the page model for an example
     */
    public static function showChildren()
    {
        return true;
    }

    /**
     * whether this item allows deletion on the admin index page
     */
    public function allowDelete(): bool
    {
        //don't allow deletion of the home page with an empty slug
        if(empty($this->slug) || ($this->slug=='/'))
            return false;
        
        return parent::allowDelete();
    }

    /**
    * return an array widget info
    * @return Array | null  of widgets info for display on the admin dashboard
    */
    public static function getDashboardWidgets()
    {
        $widgets=[];

        $widgets[]=[
                    'heading'=>"Total pages",
                    'text'=> 'You have had <span class="font-semi-bold text-link">98</span> enquiries this week',
                    'type'=>'bs-dashboard-widget.info',
                    'widget-order' => 1
                  ];

        $widgets[]=[
                    'heading' => "Add new page",
                    'icon' => 'page',
                    'text' => 'Create a new page and populate it with content.',
                    'type' => 'bs-dashboard-widget.action',
                    'widget-order' => 1
                ];
        return $widgets;
    }

    
    /**
     * Adds model description text under the main <h1> tag.
     * 
     * @return String content to be displayed under the the index page heading.
     */

    public static function getExtraIndexHeaderView()
    {
        return '<p class="mt-1 text-body-tertiary">Create and manage your websites pages.</p>';
    }
}