@props([
    'href' => null,
    'icon' => null,
    'label' => null,
    'removable' => false,
    'type' => null,
])

@php
    $attributes = $attributes
        ->merge([        
            
        ])
        ->class([
            'tag'
        ]);
@endphp

@if ($href)
    <a {{ $attributes }} href="{{ $href }}">
        @if ($icon)
            <x-bs-icon 
                :icon=$icon
                size="xs" 
            />
        @endif
        @if($label || !$slot->isEmpty())
            <div class="tag__label">
                {{ $label ?? $slot }}
            </div>
        @endif
        @if ($removable)
            <button class="tag__action" name="action"  data-action="remove-tag">
                <x-bs-icon 
                    icon="cross"
                    size="xs" 
                />
                <span class="sr-only">Remove {{ $label }}</span>
            </button>
        @endif
    </a>
@elseif ($type === 'button')
    <button {{ $attributes }} type="button">
        @if ($icon)
            <x-bs-icon 
                :icon=$icon
                size="xs" 
            />
        @endif
        @if($label || !$slot->isEmpty())
            <div class="tag__label">
                {{ $label ?? $slot }}
            </div>
        @endif
        @if ($removable)
            <button class="tag__action" name="action"  data-action="remove-tag">
                <x-bs-icon 
                    icon="cross"
                    size="xs" 
                />
                <span class="sr-only">Remove {{ $label }}</span>
            </button>
        @endif
    </button>
@else
    <span {{ $attributes }}>
        @if ($icon)
            <x-bs-icon 
                :icon=$icon
                size="xs" 
            />
        @endif
        @if($label || !$slot->isEmpty())
            <div class="tag__label">
                {{ $label ?? $slot }}
            </div>
        @endif
        @if ($removable)
            <button class="tag__action" name="action"  data-action="remove-tag">
                <x-bs-icon 
                    icon="cross"
                    size="xs" 
                />
                <span class="sr-only">Remove {{ $label }}</span>
            </button>
        @endif
    </span>
@endif