import A11yDialog from "../../libs/a11y-dialog";

export default () => {
    // this is used on page load, 
    // and after part of a page is reloaded by ajax to reattach dialog events

    const modals = document.querySelectorAll('[data-role="delete-post-item-modal"]');

    modals.forEach(modal => {

        const dialog = new A11yDialog(modal);
        const deleteButton = modal.querySelector('[data-action=delete-post-item]');
    
        let deleteURL = '#';
        
        dialog.on('show', function (element, event) {
            deleteURL = event.target.getAttribute('data-delete-url');
        });
    
        dialog.on('hide', function (element, event) {
            deleteURL = '#';
        })

        // Redirect window to the delete path if the delete button is clicked
        deleteButton.addEventListener('click', (event) => {
            event.preventDefault();
            window.location.assign(deleteURL);
        })

    })
    // Check if modal exists
    //if (!modal) return false;

    
}