@props([
    'prefix' => null,
    'submenu' => null
])

@php
    $attributes = $attributes
        ->merge([
            'href' => $link,
            'data-active' => $active,
        ])
        ->class([
            'navigation__item-link'
        ]);
@endphp

<x-bs-navigation.item
    active="{{ (strpos($currentPath, $url) !== false) ? 'true' : 'false' }}"
    aria-expanded="{{ (strpos($currentPath, $url) !== false) ? 'true' : 'false' }}"
    dropdown="true" 
    icon="{{ $submenu['icon'] }}" 
    label="{{ $submenu['name'] }}"
>
    <x-bs-navigation.dropdown>
        <x-bs-navigation.list>
            <x-bs-navigation.item
                active="{{ $currentPath == $url ? 'true' : 'false' }}"
                label="View {{ $submenu['name'] }}"
                link="/{{ $prefix }}/{{ $submenu['slug'] }}" 
            />
            @foreach ($submenu['subMenu'] as $submenu)
                @php
                    $dropdownUrl = $prefix.'/'.$submenu['slug'].'/'.$submenu['slug'];
                @endphp

                <x-bs-navigation.item
                    active="{{ $dropdownUrl === $currentPath ? 'true' : 'false' }}"
                    label="{{ $submenu['text'] }}"
                    link="/{{ $prefix }}/{{ $submenu['slug'] }}/{{ $submenu['slug']}}" 
                />
            @endforeach
        </x-bs-navigation.list>
    </x-bs-navigation.dropdown>
</x-bs-navigation.item>