@props([
    'group' => [
        'class' => null,
    ],
    'id' => null,
    'label' => null,
    'type' => 'hidden',
    'required' => '',
    'max' => '',
    'value' => '{}',
    'hint' => '',
    'folder' => null,
    'extraAttributes' => [],
    'filerequirements' => ['PDF, DOC, DOCX, XLS, XLSX, ODT, ODS', '.pdf, .doc, .docx, .xls, .xlsx, .odt, .ods'],
])

@php
    $attributes = $attributes->class([
        'input',
    ])->merge([
    ]);

    if(isset($extraAttributes['folder']))
        $folder=$extraAttributes['folder'];

    $href=false;
    if(isset($extraAttributes['href']))
        $href=$extraAttributes['href'];

    if(empty($folder))
        $folder=$id;

    $files=[];
    if(!empty($value))
        $files = json_decode($value, true);

    $dummyfile=[
            'url'=>'',
            'title'=>'',
            'filename'=>''
        ];
    
    if(empty($value))
        $value='{}';

    $guid = \Clevercherry\Backslash\Backslash4::generateShortUuid();    
@endphp

<x-bs-form.group class="{{ $group['class'] }}">
    @if(!empty($label))
    <x-bs-form.label :label=$label for="{{ $id.'-'.$guid }}" :hint=$hint/>
    @endif
    <input {{ $required }} {{ $attributes }}  id="{{ $id.'-'.$guid }}" type="{{ $type }}" value="{{ $value }}"/>
    <x-bs-tag-list data-tag-list="{{ $id.'-'.$guid }}">
        <x-bs-tags.file />
        @if($files)
            @foreach($files as $file)
                <x-bs-tags.file 
                    :$file
                    :$href
                />
            @endforeach
        @endif
        <x-bs-tag
            icon="plus"
            label="Add file"
            type="button"
            data-a11y-dialog-show="file-picker-{{ $id }}-modal-{{ $guid }}"
            data-action="add-file"
        />
    </x-bs-tag-list>


    <x-bs-modal.file-picker-modal id="file-picker-{{ $id }}-modal-{{ $guid }}" data-for="{{ $id.'-'.$guid }}" :folder=$folder :filerequirements=$filerequirements />
</x-bs-form.group>
